/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SingleItemFilter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ReversibleIterator;

public final class LastItemExpression
extends SingleItemFilter {
    public LastItemExpression(Expression base) {
        super(base);
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        LastItemExpression exp = new LastItemExpression(this.getBaseExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        SequenceIterator forwards = this.getBaseExpression().iterate(context);
        if (forwards instanceof ReversibleIterator) {
            return ((ReversibleIterator)forwards).getReverseIterator().next();
        }
        Item current = null;
        Item item;
        while ((item = forwards.next()) != null) {
            current = item;
        }
        return current;
    }

    @Override
    public String getExpressionName() {
        return "lastOf";
    }

    @Override
    public Elaborator getElaborator() {
        return new LastItemExprElaborator();
    }

    public static Item getLast(SequenceIterator iter) {
        if (iter instanceof ReversibleIterator) {
            return ((ReversibleIterator)iter).getReverseIterator().next();
        }
        Item current = null;
        Item item;
        while ((item = iter.next()) != null) {
            current = item;
        }
        return current;
    }

    public static class LastItemExprElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            LastItemExpression expr = (LastItemExpression)this.getExpression();
            PullEvaluator baseEval = expr.getBaseExpression().makeElaborator().elaborateForPull();
            return context -> LastItemExpression.getLast(baseEval.iterate(context));
        }
    }
}

