/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.function.Supplier;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;

public class ItemTypeCheckingFunction
implements ItemMappingFunction {
    private final ItemType requiredItemType;
    private final Supplier<RoleDiagnostic> roleSupplier;
    private final Location location;
    private Configuration config = null;

    public ItemTypeCheckingFunction(ItemType requiredItemType, Supplier<RoleDiagnostic> roleSupplier, Location locator, Configuration config) {
        this.requiredItemType = requiredItemType;
        this.roleSupplier = roleSupplier;
        this.location = locator;
        this.config = config;
    }

    @Override
    public Item mapItem(Item item) throws XPathException {
        this.testConformance(item, this.config);
        return item;
    }

    private void testConformance(Item item, Configuration config) throws XPathException {
        TypeHierarchy th = config.getTypeHierarchy();
        if (!(this.requiredItemType.matches(item, th) || this.requiredItemType.getUType().subsumes(UType.STRING) && BuiltInAtomicType.ANY_URI.matches(item, th))) {
            RoleDiagnostic role = this.roleSupplier.get();
            String message = role.composeErrorMessage(this.requiredItemType, item, th);
            String errorCode = role.getErrorCode();
            if ("XPDY0050".equals(errorCode)) {
                XPathException te = new XPathException(message, errorCode);
                te.setLocator(this.location);
                te.setIsTypeError(false);
                throw te;
            }
            XPathException te = new XPathException(message, errorCode);
            te.setLocator(this.location);
            te.setIsTypeError(true);
            throw te;
        }
    }
}

