/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.services;

import java.util.List;
import java.util.SortedSet;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.utils.normalizers.StationNormalizer;
import nc.ird.cantharella.service.utils.normalizers.UniqueFieldNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalize;
import org.springframework.transaction.annotation.Transactional;

public interface StationService {
    public long countStations();

    public void createStation(@Normalize(value=StationNormalizer.class) Station var1) throws DataConstraintException;

    public void deleteStation(Station var1) throws DataConstraintException;

    @Transactional(readOnly=true)
    public List<String> listStationLocalites();

    @Transactional(readOnly=true)
    public List<Station> listStations(Utilisateur var1);

    public SortedSet<Station> listStationsForUser(Utilisateur var1);

    public Station loadStation(Integer var1) throws DataNotFoundException;

    public Station loadStation(@Normalize(value=UniqueFieldNormalizer.class) String var1) throws DataNotFoundException;

    public boolean updateOrdeleteStationEnabled(Station var1, Utilisateur var2);

    public void updateStation(@Normalize(value=StationNormalizer.class) Station var1) throws DataConstraintException;
}

