/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.config;

import java.util.Properties;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.utils.normalizers.PersonneNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalizer;
import nc.ird.cantharella.utils.CantharellaConfig;
import nc.ird.cantharella.utils.PasswordTools;
import org.nuiton.util.config.ArgumentsParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Import(value={DataContext.class})
@ComponentScan(basePackages={"nc.ird.cantharella.service.services", "nc.ird.cantharella.service.utils"})
@Configuration
public abstract class ServiceContext {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceContext.class);
    private static final int MAIL_SMTP_PORT = 25;
    private static final int MAIL_SMTP_TIMEOUT = 10000;
    private static boolean mailActivated = true;
    @Value(value="${admin.courriel}")
    protected String adminCourrielProperty;
    @Value(value="${admin.password}")
    protected String adminPasswordProperty;
    @Value(value="${mail.debug}")
    protected boolean mailDebugProperty;
    @Value(value="${mail.from}")
    protected String mailFromProperty;
    @Value(value="${mail.host}")
    protected String mailHostProperty;

    public static boolean isMailActivated() {
        return mailActivated;
    }

    public static void setMailActivated(boolean mailActivated) {
        ServiceContext.mailActivated = mailActivated;
    }

    @Bean
    public Utilisateur defaultAdmin() {
        Utilisateur admin = new Utilisateur();
        admin.setTypeDroit(Utilisateur.TypeDroit.ADMINISTRATEUR);
        admin.setAdressePostale("BP A5");
        admin.setCodePostal("98848");
        admin.setCourriel(this.adminCourrielProperty);
        admin.setNom("ADMIN");
        admin.setOrganisme("IRD");
        admin.setPasswordHash(PasswordTools.sha1((String)this.adminPasswordProperty));
        admin.setCodePays("FR");
        admin.setPrenom("Admin");
        admin.setVille("Noum\u00e9a");
        Normalizer.normalize(PersonneNormalizer.class, admin);
        return admin;
    }

    @Bean
    public SimpleMailMessage mailMessage() {
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setFrom(this.mailFromProperty);
        return mailMessage;
    }

    @Bean
    public MailSender mailSender() {
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        Properties properties = new Properties();
        properties.put("mail.debug", (Object)this.mailDebugProperty);
        properties.put("mail.smtp.connectiontimeout", (Object)10000);
        properties.put("mail.smtp.timeout", (Object)10000);
        mailSender.setJavaMailProperties(properties);
        mailSender.setHost(this.mailHostProperty);
        mailSender.setPort(25);
        mailSender.setDefaultEncoding(DataContext.ENCODING);
        mailSender.setProtocol("smtp");
        return mailSender;
    }

    @Bean
    public MessageSourceAccessor serviceMessageSource() {
        ReloadableResourceBundleMessageSource serviceMessageSource = new ReloadableResourceBundleMessageSource();
        serviceMessageSource.setBasename("service");
        serviceMessageSource.setDefaultEncoding(DataContext.ENCODING);
        serviceMessageSource.setCacheSeconds(-1);
        return new MessageSourceAccessor((MessageSource)serviceMessageSource);
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer properties() {
        PropertySourcesPlaceholderConfigurer pspc = new PropertySourcesPlaceholderConfigurer();
        try {
            pspc.setProperties(CantharellaConfig.getProperties());
        }
        catch (ArgumentsParserException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        pspc.setIgnoreUnresolvablePlaceholders(true);
        return pspc;
    }
}

