/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationMap;
import org.apache.commons.configuration2.ConfigurationUtils;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;

public class Properties
extends PropertiesConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final DefaultListDelimiterHandler COMMA_LIST_DELIMITER_HANDLER = new DefaultListDelimiterHandler(',');
    private transient FileHandler fileHandler;

    public Properties() {
        this.getLayout().setGlobalSeparator("=");
        this.setListDelimiterHandler((ListDelimiterHandler)COMMA_LIST_DELIMITER_HANDLER);
        this.fileHandler = new FileHandler((FileBased)this);
        this.fileHandler.setEncoding(StandardCharsets.UTF_8.toString());
    }

    public Properties(String filename) throws ConfigurationException {
        this();
        this.fileHandler.setFileName(filename);
        this.fileHandler.load();
    }

    public Properties(File file) throws ConfigurationException {
        this();
        this.fileHandler.setFile(file);
        this.fileHandler.load();
    }

    public Properties(URL url) throws ConfigurationException {
        this();
        this.fileHandler.setURL(url);
        this.fileHandler.load();
    }

    public Properties(InputStream inputStream) throws ConfigurationException {
        this();
        this.fileHandler.load(inputStream);
    }

    public void save(CharSequence filename) throws ConfigurationException, IOException {
        FileOutputStream os = new FileOutputStream(filename.toString());
        this.fileHandler.save((OutputStream)os);
        os.close();
    }

    public void save(File file) throws ConfigurationException, IOException {
        this.save(file.toString());
    }

    public void save(OutputStream os) throws ConfigurationException {
        this.fileHandler.save(os);
    }

    public void load(CharSequence filename) throws ConfigurationException, IOException {
        FileInputStream is = new FileInputStream(filename.toString());
        this.fileHandler.load((InputStream)is);
        is.close();
    }

    public void load(File file) throws ConfigurationException, IOException {
        this.load(file.toString());
    }

    public void load(InputStream is) throws ConfigurationException {
        this.fileHandler.load(is);
    }

    public void addAll(Configuration configuration) {
        new ConfigurationMap((Configuration)this).putAll((Map)new ConfigurationMap(configuration));
    }

    public void addProperties(String key, String[] s) {
        for (String element : s) {
            super.addProperty(key, (Object)element);
        }
    }

    public void addProperty(String key, boolean b) {
        super.addProperty(key, (Object)b);
    }

    public void setProperty(String key, boolean b) {
        super.setProperty(key, (Object)b);
    }

    public void addProperty(String key, byte b) {
        super.addProperty(key, (Object)b);
    }

    public void setProperty(String key, byte b) {
        super.setProperty(key, (Object)b);
    }

    public void addProperty(String key, short s) {
        super.addProperty(key, (Object)s);
    }

    public void setProperty(String key, short s) {
        super.setProperty(key, (Object)s);
    }

    public void addProperty(String key, char c) {
        super.addProperty(key, (Object)Character.valueOf(c));
    }

    public void setProperty(String key, char b) {
        super.setProperty(key, (Object)Character.valueOf(b));
    }

    public void addProperty(String key, int i) {
        super.addProperty(key, (Object)i);
    }

    public void setProperty(String key, int i) {
        super.setProperty(key, (Object)i);
    }

    public void addProperty(String key, long l) {
        super.addProperty(key, (Object)l);
    }

    public void setProperty(String key, long l) {
        super.setProperty(key, (Object)l);
    }

    public void addProperty(String key, float f) {
        super.addProperty(key, (Object)Float.valueOf(f));
    }

    public void setProperty(String key, float f) {
        super.setProperty(key, (Object)Float.valueOf(f));
    }

    public void addProperty(String key, double d) {
        super.addProperty(key, (Object)d);
    }

    public void setProperty(String key, double d) {
        super.setProperty(key, (Object)d);
    }

    public void addProperties(Enum<?> key, String[] s) {
        for (String element : s) {
            super.addProperty(key.name().toLowerCase(), (Object)element);
        }
    }

    public void addProperty(Enum<?> key, boolean b) {
        super.addProperty(key.name().toLowerCase(), (Object)b);
    }

    public void setProperty(Enum<?> key, boolean b) {
        super.setProperty(key.name().toLowerCase(), (Object)b);
    }

    public void addProperty(Enum<?> key, byte b) {
        super.addProperty(key.name().toLowerCase(), (Object)b);
    }

    public void setProperty(Enum<?> key, byte b) {
        super.setProperty(key.name().toLowerCase(), (Object)b);
    }

    public void addProperty(Enum<?> key, short s) {
        super.addProperty(key.name().toLowerCase(), (Object)s);
    }

    public void setProperty(Enum<?> key, short s) {
        super.setProperty(key.name().toLowerCase(), (Object)s);
    }

    public void addProperty(Enum<?> key, char c) {
        super.addProperty(key.name().toLowerCase(), (Object)Character.valueOf(c));
    }

    public void setProperty(Enum<?> key, char b) {
        super.setProperty(key.name().toLowerCase(), (Object)Character.valueOf(b));
    }

    public void addProperty(Enum<?> key, int i) {
        super.addProperty(key.name().toLowerCase(), (Object)i);
    }

    public void setProperty(Enum<?> key, int i) {
        super.setProperty(key.name().toLowerCase(), (Object)i);
    }

    public void addProperty(Enum<?> key, long l) {
        super.addProperty(key.name().toLowerCase(), (Object)l);
    }

    public void setProperty(Enum<?> key, long l) {
        super.setProperty(key.name().toLowerCase(), (Object)l);
    }

    public void addProperty(Enum<?> key, float f) {
        super.addProperty(key.name().toLowerCase(), (Object)Float.valueOf(f));
    }

    public void setProperty(Enum<?> key, float f) {
        super.setProperty(key.name().toLowerCase(), (Object)Float.valueOf(f));
    }

    public void addProperty(Enum<?> key, double d) {
        super.addProperty(key.name().toLowerCase(), (Object)d);
    }

    public void setProperty(Enum<?> key, double d) {
        super.setProperty(key.name().toLowerCase(), (Object)d);
    }

    public boolean containsKey(Enum<?> key) {
        return this.containsKey(key.name().toLowerCase());
    }

    public Object getProperty(Enum<?> key) {
        return this.getProperty(key.name().toLowerCase());
    }

    public void addProperty(Enum<?> key, Object arg) {
        this.addProperty(key.name().toLowerCase(), arg);
    }

    public BigDecimal getBigDecimal(Enum<?> key, BigDecimal arg) {
        return this.getBigDecimal(key.name().toLowerCase(), arg);
    }

    public BigDecimal getBigDecimal(Enum<?> key) {
        return this.getBigDecimal(key.name().toLowerCase());
    }

    public BigInteger getBigInteger(Enum<?> key, BigInteger arg) {
        return this.getBigInteger(key.name().toLowerCase(), arg);
    }

    public BigInteger getBigInteger(Enum<?> key) {
        return this.getBigInteger(key.name().toLowerCase());
    }

    public boolean getBoolean(Enum<?> key, boolean arg) {
        return this.getBoolean(key.name().toLowerCase(), arg);
    }

    public Boolean getBoolean(Enum<?> key, Boolean arg) {
        return this.getBoolean(key.name().toLowerCase(), arg);
    }

    public boolean getBoolean(Enum<?> key) {
        return this.getBoolean(key.name().toLowerCase());
    }

    public byte getByte(Enum<?> key, byte arg) {
        return this.getByte(key.name().toLowerCase(), arg);
    }

    public Byte getByte(Enum<?> key, Byte arg) {
        return this.getByte(key.name().toLowerCase(), arg);
    }

    public byte getByte(Enum<?> key) {
        return this.getByte(key.name().toLowerCase());
    }

    public double getDouble(Enum<?> key, double arg) {
        return this.getDouble(key.name().toLowerCase(), arg);
    }

    public Double getDouble(Enum<?> key, Double arg) {
        return this.getDouble(key.name().toLowerCase(), arg);
    }

    public double getDouble(Enum<?> key) {
        return this.getDouble(key.name().toLowerCase());
    }

    public float getFloat(Enum<?> key, float arg) {
        return this.getFloat(key.name().toLowerCase(), arg);
    }

    public Float getFloat(Enum<?> key, Float arg) {
        return this.getFloat(key.name().toLowerCase(), arg);
    }

    public float getFloat(Enum<?> key) {
        return this.getFloat(key.name().toLowerCase());
    }

    public int getInt(Enum<?> key, int arg) {
        return this.getInt(key.name().toLowerCase(), arg);
    }

    public int getInt(Enum<?> key) {
        return this.getInt(key.name().toLowerCase());
    }

    public Integer getInteger(Enum<?> key, Integer arg) {
        return this.getInteger(key.name().toLowerCase(), arg);
    }

    public Iterator<?> getKeys(Enum<?> key) {
        return this.getKeys(key.name().toLowerCase());
    }

    public List<Object> getList(Enum<?> key, List<Object> arg) {
        return this.getList(key.name().toLowerCase(), arg);
    }

    public List<?> getList(Enum<?> key) {
        return this.getList(key.name().toLowerCase());
    }

    public long getLong(Enum<?> key, long arg) {
        return this.getLong(key.name().toLowerCase(), arg);
    }

    public Long getLong(Enum<?> key, Long arg) {
        return this.getLong(key.name().toLowerCase(), arg);
    }

    public long getLong(Enum<?> key) {
        return this.getLong(key.name().toLowerCase());
    }

    public java.util.Properties getProperties(Enum<?> key, java.util.Properties arg) {
        return this.getProperties(key.name().toLowerCase(), arg);
    }

    public java.util.Properties getProperties(Enum<?> key) {
        return this.getProperties(key.name().toLowerCase());
    }

    public short getShort(Enum<?> key, short arg) {
        return this.getShort(key.name().toLowerCase(), arg);
    }

    public Short getShort(Enum<?> key, Short arg) {
        return this.getShort(key.name().toLowerCase(), arg);
    }

    public short getShort(Enum<?> key) {
        return this.getShort(key.name().toLowerCase());
    }

    public String getString(Enum<?> key, String arg) {
        return this.getString(key.name().toLowerCase(), arg);
    }

    public String getString(Enum<?> key) {
        return this.getString(key.name().toLowerCase());
    }

    public String[] getStringArray(Enum<?> key) {
        return this.getStringArray(key.name().toLowerCase());
    }

    public void setProperty(Enum<?> key, Object arg) {
        this.setProperty(key.name().toLowerCase(), arg);
    }

    public Configuration subset(Enum<?> key) {
        return this.subset(key.name().toLowerCase());
    }

    public String toString() {
        return ConfigurationUtils.toString((Configuration)this);
    }

    public int hashCode() {
        int h = 0;
        Iterator i = this.getKeys();
        while (i.hasNext()) {
            h = h * 31 + Arrays.hashCode(this.getStringArray((String)i.next()));
        }
        return h;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Properties)) {
            return false;
        }
        Properties p = (Properties)o;
        Iterator i = this.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object[] value = p.getStringArray(key);
            if (value != null && Arrays.equals(this.getStringArray(key), value)) continue;
            return false;
        }
        i = p.getKeys();
        while (i.hasNext()) {
            if (this.getStringArray((String)i.next()) != null) continue;
            return false;
        }
        return true;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.fileHandler = new FileHandler((FileBased)this);
        this.fileHandler.setEncoding(StandardCharsets.UTF_8.toString());
        try {
            this.fileHandler.save((OutputStream)s);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.fileHandler = new FileHandler((FileBased)this);
        this.fileHandler.setEncoding(StandardCharsets.UTF_8.toString());
        try {
            this.fileHandler.load((InputStream)s);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

