/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import com.google.common.io.ByteStreams;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.PrefixCoderTransformationStrategy;
import it.unimi.dsi.compression.Decoder;
import it.unimi.dsi.compression.HuTuckerCodec;
import it.unimi.dsi.compression.PrefixCoder;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.io.FileLinesMutableStringIterable;
import it.unimi.dsi.io.InputBitStream;
import it.unimi.dsi.io.OutputBitStream;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.util.AbstractPrefixMap;
import it.unimi.dsi.util.ImmutableBinaryTrie;
import it.unimi.dsi.util.Interval;
import it.unimi.dsi.util.Intervals;
import it.unimi.dsi.util.StringMaps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;

public class ImmutableExternalPrefixMap
extends AbstractPrefixMap
implements Serializable {
    private static final boolean DEBUG = false;
    public static final long serialVersionUID = 1L;
    public static final int STD_BLOCK_SIZE = 1024;
    public static final int CACHE_MAX_SIZE = 1024;
    protected final ImmutableBinaryTrie<CharSequence> intervalApproximator;
    protected final long blockSize;
    protected final Decoder decoder;
    protected final char[] symbol2char;
    protected final Char2IntOpenHashMap char2symbol;
    protected final int size;
    protected final int[] blockStart;
    protected final int[] blockOffset;
    protected final boolean selfContained;
    private final long dumpStreamLength;
    private transient String tempDumpStreamFilename;
    protected transient boolean iteratorIsUsable;
    protected transient InputBitStream dumpStream;
    protected transient Object2IntLinkedOpenHashMap<MutableString> cache;

    public ImmutableExternalPrefixMap(Iterable<? extends CharSequence> terms, int blockSizeInBytes, CharSequence dumpStreamFilename) throws IOException {
        OutputBitStream output;
        BitVector[] codeWord;
        PrefixCoder prefixCoder;
        HuTuckerCodec codec;
        this.blockSize = blockSizeInBytes * 8;
        this.selfContained = dumpStreamFilename == null;
        int[] frequency = new int[65536];
        int maxWordLength = 0;
        int count = 0;
        MutableString prevTerm = new MutableString();
        for (CharSequence charSequence : terms) {
            maxWordLength = Math.max(charSequence.length(), maxWordLength);
            int j = charSequence.length();
            while (j-- != 0) {
                char c = charSequence.charAt(j);
                frequency[c] = frequency[c] + 1;
            }
            int cmp = prevTerm.compareTo(charSequence);
            if (count > 0 && cmp >= 0) {
                throw new IllegalArgumentException("The provided term collection " + (cmp == 0 ? "contains duplicates" : "is not sorted") + " [" + prevTerm + ", " + charSequence + "]");
            }
            ++count;
            prevTerm.replace(charSequence);
        }
        this.size = count;
        count = 0;
        int i = frequency.length;
        while (i-- != 0) {
            if (frequency[i] == 0) continue;
            ++count;
        }
        int[] packedFrequency = new int[count];
        this.symbol2char = new char[count];
        this.char2symbol = new Char2IntOpenHashMap(count);
        this.char2symbol.defaultReturnValue(-1);
        int i2 = frequency.length;
        int k = count;
        while (i2-- != 0) {
            if (frequency[i2] == 0) continue;
            packedFrequency[--k] = frequency[i2];
            this.symbol2char[k] = (char)i2;
            this.char2symbol.put((char)i2, k);
        }
        this.char2symbol.trim();
        if (packedFrequency.length != 0) {
            codec = new HuTuckerCodec(packedFrequency);
            prefixCoder = codec.coder();
            this.decoder = codec.decoder();
            codeWord = prefixCoder.codeWords();
        } else {
            codec = null;
            prefixCoder = null;
            this.decoder = null;
            codeWord = null;
        }
        frequency = null;
        packedFrequency = null;
        if (this.selfContained) {
            File temp = File.createTempFile(this.getClass().getName(), ".dump");
            temp.deleteOnExit();
            this.tempDumpStreamFilename = temp.toString();
            output = new OutputBitStream(temp, blockSizeInBytes);
        } else {
            this.tempDumpStreamFilename = dumpStreamFilename.toString();
            output = new OutputBitStream(this.tempDumpStreamFilename, blockSizeInBytes);
        }
        int prevTermLength = 0;
        int prefixLength = 0;
        int termCount = 0;
        int currBuffer = 0;
        IntArrayList blockStarts = new IntArrayList();
        IntArrayList blockOffsets = new IntArrayList();
        ObjectArrayList delimiters = new ObjectArrayList();
        prevTerm.length(0);
        Iterator<? extends CharSequence> iterator = terms.iterator();
        while (iterator.hasNext()) {
            int j;
            CharSequence name;
            CharSequence charSequence = name = iterator.next();
            int length = charSequence.length();
            boolean isDelimiter = false;
            int bits = 0;
            for (prefixLength = 0; prefixLength < length && prefixLength < prevTermLength && prevTerm.charAt(prefixLength) == charSequence.charAt(prefixLength); ++prefixLength) {
            }
            for (j = prefixLength; j < length; ++j) {
                bits = (int)((long)bits + codeWord[this.char2symbol.get(charSequence.charAt(j))].length());
            }
            if (output.writtenBits() % this.blockSize != 0L && output.writtenBits() / this.blockSize != (output.writtenBits() + (long)(length - prefixLength + 1) + (long)(prefixLength + 1) + (long)bits - 1L) / this.blockSize) {
                j = (int)(this.blockSize - output.writtenBits() % this.blockSize);
                while (j-- != 0) {
                    output.writeBit(0);
                }
                assert (output.writtenBits() % this.blockSize == 0L);
            }
            if (output.writtenBits() % this.blockSize == 0L) {
                isDelimiter = true;
                prefixLength = 0;
                blockOffsets.add((int)(output.writtenBits() / this.blockSize));
            }
            if (!isDelimiter) {
                output.writeUnary(prefixLength);
            }
            output.writeUnary(length - prefixLength);
            for (j = prefixLength; j < length; ++j) {
                BitVector c = codeWord[this.char2symbol.get(charSequence.charAt(j))];
                for (long k2 = 0L; k2 < c.size64(); ++k2) {
                    output.writeBit(c.getBoolean(k2));
                }
            }
            if (isDelimiter) {
                blockStarts.add(termCount);
                delimiters.add((Object)new MutableString(charSequence));
            }
            currBuffer = 1 - currBuffer;
            prevTerm.replace(charSequence);
            prevTermLength = length;
            ++termCount;
        }
        output.align();
        this.dumpStreamLength = output.writtenBits() / 8L;
        output.close();
        this.intervalApproximator = prefixCoder == null ? null : new ImmutableBinaryTrie<CharSequence>((Iterable<CharSequence>)delimiters, new PrefixCoderTransformationStrategy(prefixCoder, this.char2symbol, false));
        blockStarts.add(this.size);
        this.blockStart = blockStarts.toIntArray();
        this.blockOffset = blockOffsets.toIntArray();
        this.dumpStream = new InputBitStream(this.tempDumpStreamFilename, blockSizeInBytes);
        this.cache = new Object2IntLinkedOpenHashMap();
        this.cache.defaultReturnValue(-1);
    }

    public ImmutableExternalPrefixMap(Iterable<? extends CharSequence> terms, CharSequence dumpStreamFilename) throws IOException {
        this(terms, 1024, dumpStreamFilename);
    }

    public ImmutableExternalPrefixMap(Iterable<? extends CharSequence> terms, int blockSizeInBytes) throws IOException {
        this(terms, blockSizeInBytes, null);
    }

    public ImmutableExternalPrefixMap(Iterable<? extends CharSequence> terms) throws IOException {
        this(terms, null);
    }

    private void safelyCloseDumpStream() {
        try {
            if (this.dumpStream != null) {
                this.dumpStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void ensureNotSelfContained() {
        if (this.selfContained) {
            throw new IllegalStateException("You cannot set the dump file of a self-contained external prefix map");
        }
    }

    private boolean isEncodable(CharSequence s) {
        int i = s.length();
        while (i-- != 0) {
            if (this.char2symbol.containsKey(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void setDumpStream(CharSequence dumpStreamFilename) throws FileNotFoundException {
        this.ensureNotSelfContained();
        this.safelyCloseDumpStream();
        this.iteratorIsUsable = false;
        long newLength = new File(dumpStreamFilename.toString()).length();
        if (newLength != this.dumpStreamLength) {
            throw new IllegalArgumentException("The size of the new dump file (" + newLength + ") does not match the original length (" + this.dumpStreamLength + ")");
        }
        this.dumpStream = new InputBitStream(dumpStreamFilename.toString(), (int)(this.blockSize / 8L));
    }

    public void setDumpStream(InputBitStream dumpStream) {
        this.ensureNotSelfContained();
        this.safelyCloseDumpStream();
        this.iteratorIsUsable = false;
        this.dumpStream = dumpStream;
    }

    private void ensureStream() {
        if (this.dumpStream == null) {
            throw new IllegalStateException("This external prefix map has been deserialised, but no dump stream has been set");
        }
    }

    @Override
    public Interval getInterval(CharSequence prefix) {
        this.ensureStream();
        if (!this.isEncodable(prefix)) {
            return Intervals.EMPTY_INTERVAL;
        }
        Interval interval = this.intervalApproximator.getApproximatedInterval(prefix);
        if (interval == Intervals.EMPTY_INTERVAL) {
            return interval;
        }
        try {
            int i;
            int suffixLength;
            int count;
            this.dumpStream.position((long)this.blockOffset[interval.left] * this.blockSize);
            this.dumpStream.readBits(0L);
            this.iteratorIsUsable = false;
            MutableString s = new MutableString();
            int prefixLength = -1;
            int blockEnd = this.blockStart[interval.left + 1];
            int start = -1;
            int end = -1;
            for (count = this.blockStart[interval.left]; count < blockEnd; ++count) {
                prefixLength = prefixLength < 0 ? 0 : this.dumpStream.readUnary();
                suffixLength = this.dumpStream.readUnary();
                s.delete(prefixLength, s.length());
                s.length(prefixLength + suffixLength);
                for (i = 0; i < suffixLength; ++i) {
                    s.charAt(i + prefixLength, this.symbol2char[this.decoder.decode(this.dumpStream)]);
                }
                if (!s.startsWith(prefix)) continue;
                start = count;
                break;
            }
            if (start < 0 && interval.length() == 1) {
                return Intervals.EMPTY_INTERVAL;
            }
            start = count;
            end = start + 1;
            if (interval.length() > 1) {
                this.dumpStream.position((long)this.blockOffset[interval.right] * this.blockSize);
                this.dumpStream.readBits(0L);
                s.length(0);
                end = this.blockStart[interval.right];
                blockEnd = this.blockStart[interval.right + 1];
                prefixLength = -1;
            }
            while (end < blockEnd) {
                prefixLength = prefixLength < 0 ? 0 : this.dumpStream.readUnary();
                suffixLength = this.dumpStream.readUnary();
                s.delete(prefixLength, s.length());
                s.length(prefixLength + suffixLength);
                for (i = 0; i < suffixLength; ++i) {
                    s.charAt(i + prefixLength, this.symbol2char[this.decoder.decode(this.dumpStream)]);
                }
                if (!s.startsWith(prefix)) break;
                ++end;
            }
            return Interval.valueOf(start, end - 1);
        }
        catch (IOException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }

    @Override
    protected MutableString getTerm(int index, MutableString s) {
        this.ensureStream();
        int block = Arrays.binarySearch(this.blockStart, index);
        if (block < 0) {
            block = -block - 2;
        }
        try {
            this.dumpStream.position((long)this.blockOffset[block] * this.blockSize);
            this.dumpStream.readBits(0L);
            this.iteratorIsUsable = false;
            int prefixLength = -1;
            int i = index - this.blockStart[block] + 1;
            while (i-- != 0) {
                prefixLength = prefixLength < 0 ? 0 : this.dumpStream.readUnary();
                int suffixLength = this.dumpStream.readUnary();
                s.delete(prefixLength, s.length());
                s.length(prefixLength + suffixLength);
                for (int j = 0; j < suffixLength; ++j) {
                    s.charAt(j + prefixLength, this.symbol2char[this.decoder.decode(this.dumpStream)]);
                }
            }
            return s;
        }
        catch (IOException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }

    private long getIndex(Object o) {
        CharSequence term = (CharSequence)o;
        int cached = this.cache.getAndMoveToFirst((Object)new MutableString(term));
        if (cached != -1) {
            return cached;
        }
        this.ensureStream();
        if (!this.isEncodable(term)) {
            return -1L;
        }
        Interval interval = this.intervalApproximator.getApproximatedInterval(term);
        if (interval == Intervals.EMPTY_INTERVAL) {
            return -1L;
        }
        try {
            this.dumpStream.position((long)this.blockOffset[interval.left] * this.blockSize);
            this.dumpStream.readBits(0L);
            this.iteratorIsUsable = false;
            MutableString s = new MutableString();
            int prefixLength = -1;
            int blockEnd = this.blockStart[interval.left + 1];
            for (int count = this.blockStart[interval.left]; count < blockEnd; ++count) {
                prefixLength = prefixLength < 0 ? 0 : this.dumpStream.readUnary();
                int suffixLength = this.dumpStream.readUnary();
                s.delete(prefixLength, s.length());
                s.length(prefixLength + suffixLength);
                for (int i = 0; i < suffixLength; ++i) {
                    s.charAt(i + prefixLength, this.symbol2char[this.decoder.decode(this.dumpStream)]);
                }
                if (!s.equals(term)) continue;
                if (this.cache.size() >= 1024) {
                    this.cache.removeFirstInt();
                }
                this.cache.put((Object)s.copy(), count);
                return count;
            }
            return -1L;
        }
        catch (IOException rethrow) {
            throw new RuntimeException(rethrow);
        }
    }

    public boolean containsKey(Object term) {
        return this.getIndex(term) != -1L;
    }

    public long getLong(Object o) {
        long result = this.getIndex(o);
        return result == -1L ? this.defRetValue : result;
    }

    public ObjectIterator<CharSequence> iterator() {
        return new DumpStreamIterator();
    }

    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.selfContained) {
            FileInputStream fis = new FileInputStream(this.tempDumpStreamFilename);
            ByteStreams.copy((InputStream)fis, (OutputStream)s);
            fis.close();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.selfContained) {
            int len;
            File temp = File.createTempFile(this.getClass().getName(), ".dump");
            temp.deleteOnExit();
            this.tempDumpStreamFilename = temp.toString();
            FileOutputStream fos = new FileOutputStream(temp);
            byte[] b = new byte[65536];
            while ((len = s.read(b)) >= 0) {
                fos.write(b, 0, len);
            }
            fos.close();
            this.dumpStream = new InputBitStream(temp, (int)(this.blockSize / 8L));
        }
        this.cache = new Object2IntLinkedOpenHashMap();
        this.cache.defaultReturnValue(-1);
    }

    public static void main(String[] arg) throws ClassNotFoundException, IOException, JSAPException, SecurityException, NoSuchMethodException {
        Iterable termList;
        SimpleJSAP jsap = new SimpleJSAP(ImmutableExternalPrefixMap.class.getName(), "Builds an external prefix map reading from standard input a newline-separated list of sorted terms or a serialised term list. If the dump stream name is not specified, the map will be self-contained.\n\nNote that if you read terms from stdin or from a serialized object all terms will have to be loaded in memory.", new Parameter[]{new FlaggedOption("blockSize", (StringParser)JSAP.INTSIZE_PARSER, "1Ki", false, 'b', "block-size", "The size of a block in the dump stream."), new Switch("serialised", 's', "serialised", "The data source (file or standard input) provides a serialised java.util.List of terms."), new Switch("synchronised", 'S', "synchronised", "The serialised map will be synchronised."), new Switch("zipped", 'z', "zipped", "The term list is compressed in gzip format."), new FlaggedOption("decompressor", (StringParser)JSAP.CLASS_PARSER, JSAP.NO_DEFAULT, false, 'd', "decompressor", "Use this extension of InputStream to decompress the terms."), new FlaggedOption("termFile", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'o', "offline", "Read terms from this file instead of standard input."), new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The term list encoding."), new UnflaggedOption("map", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised map."), new UnflaggedOption("dump", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "An optional dump stream (the resulting map will not be self-contained).")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        String termFile = jsapResult.getString("termFile");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        boolean zipped = jsapResult.getBoolean("zipped");
        Class<GZIPInputStream> decompressor = jsapResult.getClass("decompressor");
        boolean serialised = jsapResult.getBoolean("serialised");
        boolean synchronised = jsapResult.getBoolean("synchronised");
        if (zipped && decompressor != null) {
            throw new IllegalArgumentException("The zipped and decompressor options are incompatible");
        }
        if ((zipped || decompressor != null) && serialised) {
            throw new IllegalArgumentException("The zipped/decompressor and serialised options are incompatible");
        }
        if (zipped) {
            decompressor = GZIPInputStream.class;
        }
        if (serialised) {
            termList = (List)(termFile != null ? BinIO.loadObject((CharSequence)termFile) : BinIO.loadObject((InputStream)System.in));
        } else if (termFile != null) {
            termList = new FileLinesMutableStringIterable(termFile, encoding, decompressor);
        } else {
            ObjectArrayList list = new ObjectArrayList();
            termList = list;
            FileLinesMutableStringIterable.iterator(System.in, encoding, decompressor).forEachRemaining(s -> list.add((Object)s.toString()));
        }
        ImmutableExternalPrefixMap immutableExternalPrefixMap = new ImmutableExternalPrefixMap(termList, jsapResult.getInt("blockSize"), jsapResult.getString("dump"));
        BinIO.storeObject((Object)(synchronised ? StringMaps.synchronize(immutableExternalPrefixMap) : immutableExternalPrefixMap), (CharSequence)jsapResult.getString("map"));
    }

    private final class DumpStreamIterator
    implements ObjectIterator<CharSequence> {
        private int currBlock = -1;
        private int index;
        final MutableString s = new MutableString();

        private DumpStreamIterator() {
            try {
                ImmutableExternalPrefixMap.this.dumpStream.position(0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ImmutableExternalPrefixMap.this.dumpStream.readBits(0L);
            ImmutableExternalPrefixMap.this.iteratorIsUsable = true;
        }

        public boolean hasNext() {
            if (!ImmutableExternalPrefixMap.this.iteratorIsUsable) {
                throw new IllegalStateException("Get methods of this map have caused a stream repositioning");
            }
            return this.index < ImmutableExternalPrefixMap.this.size;
        }

        public CharSequence next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                int prefixLength;
                if (this.index == ImmutableExternalPrefixMap.this.blockStart[this.currBlock + 1]) {
                    if (ImmutableExternalPrefixMap.this.dumpStream.readBits() % ImmutableExternalPrefixMap.this.blockSize != 0L) {
                        ImmutableExternalPrefixMap.this.dumpStream.skip(ImmutableExternalPrefixMap.this.blockSize - ImmutableExternalPrefixMap.this.dumpStream.readBits() % ImmutableExternalPrefixMap.this.blockSize);
                    }
                    ++this.currBlock;
                    prefixLength = 0;
                } else {
                    prefixLength = ImmutableExternalPrefixMap.this.dumpStream.readUnary();
                }
                int suffixLength = ImmutableExternalPrefixMap.this.dumpStream.readUnary();
                this.s.delete(prefixLength, this.s.length());
                this.s.length(prefixLength + suffixLength);
                for (int i = 0; i < suffixLength; ++i) {
                    this.s.charAt(i + prefixLength, ImmutableExternalPrefixMap.this.symbol2char[ImmutableExternalPrefixMap.this.decoder.decode(ImmutableExternalPrefixMap.this.dumpStream)]);
                }
                ++this.index;
                return this.s;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

