/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt.classpath;

import io.takari.maven.plugins.compile.jdt.classpath.ClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.MutableClasspathEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class Classpath
implements INameEnvironment,
SuffixConstants {
    private final List<ClasspathEntry> entries;
    private final List<MutableClasspathEntry> mutableentries;
    private Map<String, Collection<ClasspathEntry>> packages;

    public Classpath(List<ClasspathEntry> entries, List<MutableClasspathEntry> localentries) {
        this.entries = entries;
        this.mutableentries = localentries;
        this.packages = Classpath.newPackageIndex(entries);
    }

    private static Map<String, Collection<ClasspathEntry>> newPackageIndex(List<ClasspathEntry> entries) {
        HashMap<String, Collection<ClasspathEntry>> classpath = new HashMap<String, Collection<ClasspathEntry>>();
        for (ClasspathEntry entry : entries) {
            for (String packageName : entry.getPackageNames()) {
                ArrayList<ClasspathEntry> packageEntries = (ArrayList<ClasspathEntry>)classpath.get(packageName);
                if (packageEntries == null) {
                    packageEntries = new ArrayList<ClasspathEntry>();
                    classpath.put(packageName, packageEntries);
                }
                packageEntries.add(entry);
            }
        }
        return classpath;
    }

    public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        if (compoundTypeName == null) {
            return null;
        }
        int typeNameIndex = compoundTypeName.length - 1;
        char[][] packageName = CharOperation.subarray((char[][])compoundTypeName, (int)0, (int)typeNameIndex);
        return this.findType(new String(CharOperation.concatWith((char[][])packageName, (char)'/')), new String(compoundTypeName[typeNameIndex]));
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        return this.findType(new String(CharOperation.concatWith((char[][])packageName, (char)'/')), new String(typeName));
    }

    private NameEnvironmentAnswer findType(String packageName, String typeName) {
        List<ClasspathEntry> entries;
        NameEnvironmentAnswer suggestedAnswer = null;
        Collection<ClasspathEntry> collection = entries = !packageName.isEmpty() ? this.packages.get(packageName) : this.entries;
        if (entries != null) {
            String binaryFileName = String.valueOf(typeName) + ".class";
            for (ClasspathEntry entry : entries) {
                NameEnvironmentAnswer answer = entry.findType(packageName, binaryFileName);
                if (answer == null) continue;
                if (!answer.ignoreIfBetter()) {
                    if (!answer.isBetter(suggestedAnswer)) continue;
                    return answer;
                }
                if (!answer.isBetter(suggestedAnswer)) continue;
                suggestedAnswer = answer;
            }
        }
        return suggestedAnswer;
    }

    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        String name = new String(CharOperation.concatWith((char[][])parentPackageName, (char[])packageName, (char)'/'));
        return this.packages.containsKey(name);
    }

    public void cleanup() {
    }

    public void reset() {
        if (this.mutableentries == null) {
            return;
        }
        for (MutableClasspathEntry entry : this.mutableentries) {
            entry.reset();
        }
        this.packages = Classpath.newPackageIndex(this.entries);
    }

    public List<ClasspathEntry> getEntries() {
        return this.entries;
    }
}

