/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import io.takari.maven.plugins.compile.jdt.classpath.ClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.MutableClasspathEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

class CompileQueueClasspathEntry
implements ClasspathEntry,
MutableClasspathEntry {
    private final Set<ICompilationUnit> compileQueue;
    private Set<String> packageNames;
    private Map<String, ICompilationUnit> units;

    public CompileQueueClasspathEntry(Set<ICompilationUnit> compileQueue) {
        this.compileQueue = compileQueue;
        this.reset();
    }

    @Override
    public Collection<String> getPackageNames() {
        return this.packageNames;
    }

    @Override
    public NameEnvironmentAnswer findType(String packageName, String binaryFileName) {
        ICompilationUnit unit = this.units.get(String.valueOf(packageName) + "/" + binaryFileName);
        if (unit != null) {
            return new NameEnvironmentAnswer(unit, null);
        }
        return null;
    }

    @Override
    public void reset() {
        HashSet<String> packageNames = new HashSet<String>();
        HashMap<String, ICompilationUnit> units = new HashMap<String, ICompilationUnit>();
        for (ICompilationUnit unit : this.compileQueue) {
            String packageName = new String(CharOperation.concatWith((char[][])unit.getPackageName(), (char)'/'));
            String binaryFileName = String.valueOf(new String(unit.getMainTypeName())) + ".CLASS";
            packageNames.add(packageName);
            units.put(String.valueOf(packageName) + "/" + binaryFileName, unit);
            int last = packageName.lastIndexOf(47);
            while (last > 0) {
                packageName = packageName.substring(0, last);
                packageNames.add(packageName);
                last = packageName.lastIndexOf(47);
            }
        }
        this.packageNames = Collections.unmodifiableSet(packageNames);
        this.units = Collections.unmodifiableMap(units);
    }

    @Override
    public String getEntryDescription() {
        return "#COMPILEQUEUE";
    }
}

