/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.model;

import io.smallrye.openapi.model.BaseModelSupport;
import io.smallrye.openapi.model.ModelLogging;
import io.smallrye.openapi.model.PropertyMetadata;
import io.smallrye.openapi.model.ReferenceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.Reference;

public abstract class BaseModel<C extends Constructible> {
    private Map<String, Object> properties = new LinkedHashMap<String, Object>(2);
    private int modCount;
    private int hash = 0;

    public static <O extends Constructible> O deepCopy(O other, Class<O> type) {
        return BaseModel.deepCopy(other, type, false);
    }

    public static <O extends Constructible> O deepCopy(O other, Class<O> type, boolean unmodifiable) {
        return BaseModelSupport.deepCopy(other, type, unmodifiable);
    }

    public static <C extends Constructible, T extends BaseModel<C>> T merge(T object1, T object2) {
        return BaseModelSupport.mergeObjects(object1, object2);
    }

    protected BaseModel() {
    }

    protected void incrementModCount() {
        ++this.modCount;
    }

    public int getModCount() {
        return this.modCount;
    }

    Map<String, Object> getProperties() {
        return this.properties;
    }

    void setUnmodifiable() {
        this.properties = Collections.unmodifiableMap(this.properties);
    }

    public String toString() {
        return String.valueOf(this.properties);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof BaseModel) {
            return Objects.equals(this.properties, ((BaseModel)obj).properties);
        }
        return false;
    }

    public int hashCode() {
        int result;
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = result = BaseModelSupport.hash(new IdentityHashMap<Object, Object>(), this);
        return result;
    }

    public C constructible() {
        return (C)((Constructible)this);
    }

    public abstract PropertyMetadata getPropertyMetadata();

    public C filter(OASFilter filter, Map<Object, Object> stack) {
        this.modCount += BaseModelSupport.filter(filter, stack, this.properties);
        return this.filter(filter);
    }

    protected C filter(OASFilter filter) {
        return (C)((Constructible)this);
    }

    protected boolean isExtension(String name) {
        return false;
    }

    public <T extends BaseModel<C>> void merge(T other) {
        for (Map.Entry<String, Object> entry : other.getProperties().entrySet()) {
            String name = entry.getKey();
            MergeDirective mergeDirective = this.mergeDirective(name);
            Object newValue = entry.getValue();
            Object oldValue = this.properties.get(entry.getKey());
            if (oldValue == other || newValue == this) {
                ModelLogging.logger.cylicReferenceAvoided(name, this.getClass().getName());
                return;
            }
            if (oldValue != null && mergeDirective == MergeDirective.PRESERVE_VALUE) continue;
            if (oldValue == null || oldValue.getClass() != newValue.getClass() || mergeDirective == MergeDirective.OVERRIDE_VALUE) {
                this.properties.put(name, newValue);
                continue;
            }
            if (oldValue instanceof BaseModel) {
                BaseModel oldModel = (BaseModel)oldValue;
                BaseModel newModel = (BaseModel)newValue;
                oldModel.merge(newModel);
                continue;
            }
            if (oldValue instanceof Map) {
                this.properties.put(name, BaseModelSupport.mergeObjects(oldValue, newValue));
                continue;
            }
            if (oldValue instanceof List) {
                this.properties.put(name, BaseModelSupport.mergeObjects(oldValue, newValue));
                continue;
            }
            this.properties.put(name, newValue);
        }
    }

    protected MergeDirective mergeDirective(String name) {
        return MergeDirective.MERGE_VALUES;
    }

    public Map<String, Object> getAllProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setAllProperties(Map<String, ?> allProperties) {
        this.properties.clear();
        if (allProperties != null) {
            allProperties.forEach(this::setProperty);
        }
    }

    protected <T> Map<String, T> getProperties(Class<T> type) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.properties.size());
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            if (!type.isInstance(entry.getValue()) || this.isExtension(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    protected <T> T getProperty(String name) {
        return (T)this.properties.get(name);
    }

    protected <T> T getProperty(String name, Class<T> type) {
        T value = this.getProperty(name);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        return null;
    }

    public <T> void setProperty(String name, T value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
        this.incrementModCount();
    }

    protected <T> List<T> getListProperty(String name) {
        T value = this.getProperty(name);
        if (value instanceof List) {
            return Collections.unmodifiableList((List)value);
        }
        return null;
    }

    protected <T> void setListProperty(String name, List<T> value) {
        value = value != null ? new ArrayList(value) : null;
        this.setProperty(name, value);
    }

    protected <T> void addListPropertyEntry(String name, T value) {
        if (value != null) {
            ArrayList<T> list = this.getProperty(name, List.class);
            if (list == null) {
                list = new ArrayList<T>(2);
            }
            list.add(value);
            this.setProperty(name, list);
        }
    }

    protected <T> void removeListPropertyEntry(String name, T value) {
        List list = this.getProperty(name, List.class);
        if (list != null) {
            list.remove(value);
        }
        this.incrementModCount();
    }

    protected <T> Map<String, T> getMapProperty(String name) {
        T value = this.getProperty(name);
        if (value instanceof Map) {
            return Collections.unmodifiableMap((Map)value);
        }
        return null;
    }

    protected <T> void setMapProperty(String name, Map<String, T> value) {
        value = value != null ? new LinkedHashMap(value) : null;
        this.setProperty(name, value);
    }

    protected <V> void putMapPropertyEntry(String name, String key, V value) {
        if (value != null) {
            LinkedHashMap<String, V> map = this.getProperty(name, Map.class);
            if (map == null) {
                map = new LinkedHashMap<String, V>(2);
            }
            map.put(key, value);
            this.setProperty(name, map);
        }
    }

    protected <V> void removeMapPropertyEntry(String name, String key) {
        Map map = this.getProperty(name, Map.class);
        if (map != null) {
            map.remove(key);
        }
        this.incrementModCount();
    }

    public String getRef() {
        return this.getProperty("$ref", String.class);
    }

    public void setRef(String ref) {
        if (ref != null && !ref.contains("/") && this instanceof Reference) {
            ref = ReferenceType.fromModel((Reference)this).referenceOf(ref);
        }
        this.setProperty("$ref", ref);
    }

    public String getName() {
        return (String)this.getProperty("name");
    }

    public void setName(String newValue) {
        this.setProperty("name", newValue);
    }

    public String getSummary() {
        return this.getProperty("summary", String.class);
    }

    public void setSummary(String summary) {
        this.setProperty("summary", summary);
    }

    public String getDescription() {
        return this.getProperty("description", String.class);
    }

    public void setDescription(String description) {
        this.setProperty("description", description);
    }

    public ExternalDocumentation getExternalDocs() {
        return (ExternalDocumentation)this.getProperty("externalDocs");
    }

    public void setExternalDocs(ExternalDocumentation newValue) {
        this.setProperty("externalDocs", newValue);
    }

    protected static enum MergeDirective {
        PRESERVE_VALUE,
        OVERRIDE_VALUE,
        MERGE_VALUES;

    }
}

