package io.vertx.mutiny.ext.web.client;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;

/**
 * An asynchronous HTTP / HTTP/2 client called <code>WebClient</code>.
 * <p>
 * The web client makes easy to do HTTP request/response interactions with a web server, and provides advanced
 * features like:
 * <ul>
 *   <li>Json body encoding / decoding</li>
 *   <li>request/response pumping</li>
 *   <li>error handling</li>
 * </ul>
 * <p>
 * The web client does not deprecate the , it is actually based on it and therefore inherits
 * its configuration and great features like pooling. The <code>HttpClient</code> should be used when fine grained control over the HTTP
 * requests/response is necessary.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.client.WebClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.client.WebClient.class)
public class WebClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<WebClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WebClient((io.vertx.ext.web.client.WebClient) obj),
    WebClient::getDelegate
  );

  private final io.vertx.ext.web.client.WebClient delegate;
  
  public WebClient(io.vertx.ext.web.client.WebClient delegate) {
    this.delegate = delegate;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  WebClient() {    this.delegate = null;
  }

  public io.vertx.ext.web.client.WebClient getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_3 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_12 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_10 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_18 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_27 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_2 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_15 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_34 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_16 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_13 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_36 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_32 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_11 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_31 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_28 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_6 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_26 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_1 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_14 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_22 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_29 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_37 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_33 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_4 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_24 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_8 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_30 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_35 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_9 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_7 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_0 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_20 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_23 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_21 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_19 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_5 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_17 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer> TYPE_ARG_25 = new io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.core.buffer.Buffer>(o1 -> io.vertx.mutiny.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebClient that = (WebClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vertx instance
   * @return the created web client
   */
  public static io.vertx.mutiny.ext.web.client.WebClient create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.web.client.WebClient ret = io.vertx.mutiny.ext.web.client.WebClient.newInstance(io.vertx.ext.web.client.WebClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param options the Web Client options
   * @return the created web client
   */
  public static io.vertx.mutiny.ext.web.client.WebClient create(io.vertx.mutiny.core.Vertx vertx, WebClientOptions options) { 
    io.vertx.mutiny.ext.web.client.WebClient ret = io.vertx.mutiny.ext.web.client.WebClient.newInstance(io.vertx.ext.web.client.WebClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * @param httpClient the  to wrap
   * @return the web client
   */
  public static io.vertx.mutiny.ext.web.client.WebClient wrap(io.vertx.mutiny.core.http.HttpClient httpClient) { 
    io.vertx.mutiny.ext.web.client.WebClient ret = io.vertx.mutiny.ext.web.client.WebClient.newInstance(io.vertx.ext.web.client.WebClient.wrap(httpClient.getDelegate()));
    return ret;
  }

  /**
   * @param httpClient the  to wrap
   * @param options the Web Client options
   * @return the web client
   */
  public static io.vertx.mutiny.ext.web.client.WebClient wrap(io.vertx.mutiny.core.http.HttpClient httpClient, WebClientOptions options) { 
    io.vertx.mutiny.ext.web.client.WebClient ret = io.vertx.mutiny.ext.web.client.WebClient.newInstance(io.vertx.ext.web.client.WebClient.wrap(httpClient.getDelegate(), options));
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(HttpMethod method, int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.request(method, port, host, requestURI), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param port 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.request(method, serverAddress.getDelegate(), port, host, requestURI), TYPE_ARG_1);
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(HttpMethod method, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.request(method, host, requestURI), TYPE_ARG_2);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param host 
   * @param requestURI 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.request(method, serverAddress.getDelegate(), host, requestURI), TYPE_ARG_3);
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(HttpMethod method, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.request(method, requestURI), TYPE_ARG_4);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param requestURI 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.request(method, serverAddress.getDelegate(), requestURI), TYPE_ARG_5);
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param options the request options
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(HttpMethod method, RequestOptions options) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.request(method, options), TYPE_ARG_6);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param options 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, RequestOptions options) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.request(method, serverAddress.getDelegate(), options), TYPE_ARG_7);
    return ret;
  }

  /**
   * @param method the HTTP method
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> requestAbs(HttpMethod method, String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.requestAbs(method, absoluteURI), TYPE_ARG_8);
    return ret;
  }

  /**
   * @param method 
   * @param serverAddress 
   * @param absoluteURI 
   * @return 
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> requestAbs(HttpMethod method, io.vertx.mutiny.core.net.SocketAddress serverAddress, String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.requestAbs(method, serverAddress.getDelegate(), absoluteURI), TYPE_ARG_9);
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> get(String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.get(requestURI), TYPE_ARG_10);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> get(int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.get(port, host, requestURI), TYPE_ARG_11);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> get(String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.get(host, requestURI), TYPE_ARG_12);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> getAbs(String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.getAbs(absoluteURI), TYPE_ARG_13);
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> post(String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.post(requestURI), TYPE_ARG_14);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> post(int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.post(port, host, requestURI), TYPE_ARG_15);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> post(String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.post(host, requestURI), TYPE_ARG_16);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> postAbs(String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.postAbs(absoluteURI), TYPE_ARG_17);
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> put(String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.put(requestURI), TYPE_ARG_18);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> put(int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.put(port, host, requestURI), TYPE_ARG_19);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> put(String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.put(host, requestURI), TYPE_ARG_20);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> putAbs(String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.putAbs(absoluteURI), TYPE_ARG_21);
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> delete(String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.delete(requestURI), TYPE_ARG_22);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> delete(int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.delete(port, host, requestURI), TYPE_ARG_23);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> delete(String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.delete(host, requestURI), TYPE_ARG_24);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> deleteAbs(String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.deleteAbs(absoluteURI), TYPE_ARG_25);
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> patch(String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.patch(requestURI), TYPE_ARG_26);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> patch(int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.patch(port, host, requestURI), TYPE_ARG_27);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> patch(String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.patch(host, requestURI), TYPE_ARG_28);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> patchAbs(String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.patchAbs(absoluteURI), TYPE_ARG_29);
    return ret;
  }

  /**
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> head(String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.head(requestURI), TYPE_ARG_30);
    return ret;
  }

  /**
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> head(int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.head(port, host, requestURI), TYPE_ARG_31);
    return ret;
  }

  /**
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> head(String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.head(host, requestURI), TYPE_ARG_32);
    return ret;
  }

  /**
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> headAbs(String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.headAbs(absoluteURI), TYPE_ARG_33);
    return ret;
  }

  /**
   * @param customHttpMethod custom HTTP Method
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> raw(String customHttpMethod, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.raw(customHttpMethod, requestURI), TYPE_ARG_34);
    return ret;
  }

  /**
   * @param customHttpMethod custom HTTP Method
   * @param port the port
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> raw(String customHttpMethod, int port, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.raw(customHttpMethod, port, host, requestURI), TYPE_ARG_35);
    return ret;
  }

  /**
   * @param customHttpMethod custom HTTP Method
   * @param host the host
   * @param requestURI the relative URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> raw(String customHttpMethod, String host, String requestURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.raw(customHttpMethod, host, requestURI), TYPE_ARG_36);
    return ret;
  }

  /**
   * @param customHttpMethod custom HTTP Method
   * @param absoluteURI the absolute URI
   * @return an HTTP client request object
   */
  public io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> rawAbs(String customHttpMethod, String absoluteURI) { 
    io.vertx.mutiny.ext.web.client.HttpRequest<io.vertx.mutiny.core.buffer.Buffer> ret = io.vertx.mutiny.ext.web.client.HttpRequest.newInstance(delegate.rawAbs(customHttpMethod, absoluteURI), TYPE_ARG_37);
    return ret;
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  public static  WebClient newInstance(io.vertx.ext.web.client.WebClient arg) {
    return arg != null ? new WebClient(arg) : null;
  }

}
