/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.ClassHierarchyResolver;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.extras.constant.ConstantUtils;
import io.smallrye.classfile.impl.ClassFileImpl;
import io.smallrye.classfile.impl.ClassReaderImpl;
import io.smallrye.classfile.impl.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public final class ClassHierarchyImpl {
    public static final ClassHierarchyResolver DEFAULT_RESOLVER = new ClassLoadingClassHierarchyResolver(ClassLoadingClassHierarchyResolver.SYSTEM_CLASS_PROVIDER);
    private final ClassHierarchyResolver resolver;

    public ClassHierarchyImpl(ClassHierarchyResolver classHierarchyResolver) {
        Objects.requireNonNull(classHierarchyResolver);
        this.resolver = classHierarchyResolver instanceof CachedClassHierarchyResolver ? classHierarchyResolver : classHierarchyResolver.cached();
    }

    private ClassHierarchyInfoImpl resolve(ClassDesc classDesc) {
        ClassHierarchyResolver.ClassHierarchyInfo res = this.resolver.getClassInfo(classDesc);
        if (res != null) {
            return (ClassHierarchyInfoImpl)res;
        }
        throw new IllegalArgumentException("Could not resolve class " + classDesc.displayName());
    }

    public boolean isInterface(ClassDesc classDesc) {
        return this.resolve(classDesc).isInterface();
    }

    public ClassDesc commonAncestor(ClassDesc symbol1, ClassDesc symbol2) {
        if (this.isInterface(symbol1) || this.isInterface(symbol2)) {
            return ConstantDescs.CD_Object;
        }
        ClassDesc s1 = symbol1;
        while (s1 != null) {
            ClassDesc s2 = symbol2;
            while (s2 != null) {
                if (s1.equals(s2)) {
                    return s1;
                }
                s2 = this.resolve(s2).superClass();
            }
            s1 = this.resolve(s1).superClass();
        }
        return null;
    }

    public boolean isAssignableFrom(ClassDesc thisClass, ClassDesc fromClass) {
        if (this.isInterface(fromClass)) {
            return this.resolve(thisClass).superClass() == null;
        }
        ClassDesc anc = this.commonAncestor(thisClass, fromClass);
        return anc == null || thisClass.equals(anc);
    }

    public static final class CachedClassHierarchyResolver
    implements ClassHierarchyResolver {
        private static final ClassHierarchyResolver.ClassHierarchyInfo NOPE = new ClassHierarchyInfoImpl(null, true);
        private final Map<ClassDesc, ClassHierarchyResolver.ClassHierarchyInfo> resolvedCache;
        private final Function<ClassDesc, ClassHierarchyResolver.ClassHierarchyInfo> delegateFunction;

        public CachedClassHierarchyResolver(final ClassHierarchyResolver delegate, Map<ClassDesc, ClassHierarchyResolver.ClassHierarchyInfo> resolvedCache) {
            this.resolvedCache = resolvedCache;
            this.delegateFunction = new Function<ClassDesc, ClassHierarchyResolver.ClassHierarchyInfo>(){

                @Override
                public ClassHierarchyResolver.ClassHierarchyInfo apply(ClassDesc classDesc) {
                    ClassHierarchyResolver.ClassHierarchyInfo ret = delegate.getClassInfo(classDesc);
                    return ret == null ? NOPE : ret;
                }
            };
        }

        @Override
        public ClassHierarchyResolver.ClassHierarchyInfo getClassInfo(ClassDesc classDesc) {
            ClassHierarchyResolver.ClassHierarchyInfo ret = this.resolvedCache.computeIfAbsent(classDesc, this.delegateFunction);
            return ret == NOPE ? null : ret;
        }
    }

    public record ClassHierarchyInfoImpl(ClassDesc superClass, boolean isInterface) implements ClassHierarchyResolver.ClassHierarchyInfo
    {
        static final ClassHierarchyResolver.ClassHierarchyInfo OBJECT_INFO = new ClassHierarchyInfoImpl(null, false);
    }

    public static final class ClassLoadingClassHierarchyResolver
    implements ClassHierarchyResolver {
        public static final Function<ClassDesc, Class<?>> SYSTEM_CLASS_PROVIDER = new Function<ClassDesc, Class<?>>(){

            @Override
            public Class<?> apply(ClassDesc cd) {
                try {
                    return Class.forName(Util.toBinaryName(cd), false, ClassLoader.getSystemClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }
        };
        private final Function<ClassDesc, Class<?>> classProvider;

        public ClassLoadingClassHierarchyResolver(Function<ClassDesc, Class<?>> classProvider) {
            this.classProvider = classProvider;
        }

        @Override
        public ClassHierarchyResolver.ClassHierarchyInfo getClassInfo(ClassDesc cd) {
            if (!cd.isClassOrInterface()) {
                return null;
            }
            if (cd.equals(ConstantDescs.CD_Object)) {
                return ClassHierarchyResolver.ClassHierarchyInfo.ofClass(null);
            }
            Class<?> cl = this.classProvider.apply(cd);
            if (cl == null) {
                return null;
            }
            return cl.isInterface() ? ClassHierarchyResolver.ClassHierarchyInfo.ofInterface() : ClassHierarchyResolver.ClassHierarchyInfo.ofClass(ConstantUtils.referenceClassDesc(cl.getSuperclass()));
        }
    }

    public static final class StaticClassHierarchyResolver
    implements ClassHierarchyResolver {
        private final Map<ClassDesc, ClassHierarchyResolver.ClassHierarchyInfo> map;

        public StaticClassHierarchyResolver(Collection<ClassDesc> interfaceNames, Map<ClassDesc, ClassDesc> classToSuperClass) {
            this.map = new HashMap<ClassDesc, ClassHierarchyResolver.ClassHierarchyInfo>(interfaceNames.size() + classToSuperClass.size() + 1);
            this.map.put(ConstantDescs.CD_Object, ClassHierarchyInfoImpl.OBJECT_INFO);
            for (Map.Entry<ClassDesc, ClassDesc> e : classToSuperClass.entrySet()) {
                this.map.put(Objects.requireNonNull(e.getKey()), ClassHierarchyResolver.ClassHierarchyInfo.ofClass(e.getValue()));
            }
            for (ClassDesc i : interfaceNames) {
                this.map.put(Objects.requireNonNull(i), ClassHierarchyResolver.ClassHierarchyInfo.ofInterface());
            }
        }

        @Override
        public ClassHierarchyResolver.ClassHierarchyInfo getClassInfo(ClassDesc classDesc) {
            return this.map.get(classDesc);
        }
    }

    public static final class ResourceParsingClassHierarchyResolver
    implements ClassHierarchyResolver {
        public static final Function<ClassDesc, InputStream> SYSTEM_STREAM_PROVIDER = new Function<ClassDesc, InputStream>(){

            @Override
            public InputStream apply(ClassDesc cd) {
                return ClassLoader.getSystemClassLoader().getResourceAsStream(Util.toInternalName(cd) + ".class");
            }
        };
        private final Function<ClassDesc, InputStream> streamProvider;

        public ResourceParsingClassHierarchyResolver(Function<ClassDesc, InputStream> classStreamProvider) {
            this.streamProvider = classStreamProvider;
        }

        @Override
        public ClassHierarchyResolver.ClassHierarchyInfo getClassInfo(ClassDesc classDesc) {
            ClassHierarchyInfoImpl classHierarchyInfoImpl;
            block9: {
                InputStream ci = this.streamProvider.apply(classDesc);
                if (ci == null) {
                    return null;
                }
                InputStream inputStream = ci;
                try {
                    ClassReaderImpl reader = new ClassReaderImpl(ci.readAllBytes(), ClassFileImpl.DEFAULT_CONTEXT);
                    boolean isInterface = (reader.flags() & 0x200) != 0;
                    ClassDesc superClass = reader.superclassEntry().map(ClassEntry::asSymbol).orElse(null);
                    classHierarchyInfoImpl = new ClassHierarchyInfoImpl(superClass, isInterface);
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new UncheckedIOException(ioe);
                    }
                }
                inputStream.close();
            }
            return classHierarchyInfoImpl;
        }
    }
}

