/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;

public class ResumeOkFrameCodec {
    public static ByteBuf encode(ByteBufAllocator allocator, long lastReceivedClientPos) {
        ByteBuf byteBuf = FrameHeaderCodec.encodeStreamZero(allocator, FrameType.RESUME_OK, 0);
        byteBuf.writeLong(lastReceivedClientPos);
        return byteBuf;
    }

    public static long lastReceivedClientPos(ByteBuf byteBuf) {
        FrameHeaderCodec.ensureFrameType(FrameType.RESUME_OK, byteBuf);
        byteBuf.markReaderIndex();
        long lastReceivedClientPosition = byteBuf.skipBytes(FrameHeaderCodec.size()).readLong();
        byteBuf.resetReaderIndex();
        return lastReceivedClientPosition;
    }
}

