/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.security.Authenticated;
import io.quarkus.security.PermissionsAllowed;
import io.quarkus.security.spi.runtime.AuthorizationController;
import io.quarkus.security.spi.runtime.MethodDescription;
import jakarta.annotation.Priority;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Method;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;

public abstract class StandardSecurityCheckInterceptor {
    public static final String STANDARD_SECURITY_CHECK_INTERCEPTOR = StandardSecurityCheckInterceptor.class.getName();
    @Inject
    AuthorizationController controller;

    @AroundInvoke
    public Object intercept(InvocationContext ic) throws Exception {
        if (this.controller.isAuthorizationEnabled() && Arc.container() != null && Arc.container().requestContext().isActive() && CurrentRequestManager.get() != null && this.alreadyDoneByEagerSecurityHandler(CurrentRequestManager.get().getProperty(STANDARD_SECURITY_CHECK_INTERCEPTOR), ic.getMethod())) {
            ic.getContextData().put("io.quarkus.security.securityHandler", "executed");
        }
        return ic.proceed();
    }

    private boolean alreadyDoneByEagerSecurityHandler(Object methodWithFinishedChecks, Method method) {
        return methodWithFinishedChecks != null && MethodDescription.ofMethod((Method)method).equals(methodWithFinishedChecks);
    }

    @Interceptor
    @Authenticated
    @Priority(value=140)
    public static final class AuthenticatedInterceptor
    extends StandardSecurityCheckInterceptor {
    }

    @Interceptor
    @PermitAll
    @Priority(value=140)
    public static final class PermitAllInterceptor
    extends StandardSecurityCheckInterceptor {
    }

    @Interceptor
    @PermissionsAllowed(value={""})
    @Priority(value=140)
    public static final class PermissionsAllowedInterceptor
    extends StandardSecurityCheckInterceptor {
    }

    @Interceptor
    @RolesAllowed(value={""})
    @Priority(value=140)
    public static final class RolesAllowedInterceptor
    extends StandardSecurityCheckInterceptor {
    }
}

