/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common;

import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;

public interface OidcRequestFilter {
    @Deprecated(since="3.31", forRemoval=true)
    default public void filter(OidcRequestContext requestContext) {
        throw new UnsupportedOperationException("filter(OidcRequestContext requestContext) method is not implemented");
    }

    default public Uni<Void> filter(OidcRequestFilterContext requestContext) {
        return Uni.createFrom().item(() -> {
            this.filter((OidcRequestContext)requestContext);
            return null;
        });
    }

    public static class OidcRequestFilterContext
    extends OidcRequestContext {
        public OidcRequestFilterContext(HttpRequest<Buffer> request, Buffer requestBody, OidcRequestContextProperties contextProperties) {
            super(request, requestBody, contextProperties);
        }

        public final Uni<Void> runBlocking(Runnable runnable) {
            return OidcCommonUtils.runBlocking(runnable);
        }
    }

    public static class OidcRequestContext {
        final HttpRequest<Buffer> request;
        final OidcRequestContextProperties contextProperties;
        Buffer requestBody;

        public OidcRequestContext(HttpRequest<Buffer> request, Buffer requestBody, OidcRequestContextProperties contextProperties) {
            this.request = request;
            this.requestBody = requestBody;
            this.contextProperties = contextProperties;
        }

        public HttpRequest<Buffer> request() {
            return this.request;
        }

        public Buffer requestBody() {
            return this.requestBody;
        }

        public OidcRequestContextProperties contextProperties() {
            return this.contextProperties;
        }

        public void requestBody(Buffer buffer) {
            this.requestBody = buffer;
            this.contextProperties.put(OidcRequestContextProperties.REQUEST_BODY, buffer);
        }
    }
}

