/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.devtools.commands.AddExtensions;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.maven.QuarkusProjectMojoBase;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="add-extension")
public class AddExtensionMojo
extends QuarkusProjectMojoBase {
    @Parameter(property="extensions")
    Set<String> extensions;
    @Parameter(property="extension")
    String extension;

    @Override
    protected void validateParameters() throws MojoExecutionException {
        if (StringUtils.isBlank((CharSequence)this.extension) && (this.extensions == null || this.extensions.isEmpty()) || !StringUtils.isBlank((CharSequence)this.extension) && this.extensions != null && !this.extensions.isEmpty()) {
            throw new MojoExecutionException("Either the `extension` or `extensions` parameter must be set");
        }
    }

    @Override
    public void doExecute(QuarkusProject quarkusProject, MessageWriter log) throws MojoExecutionException {
        HashSet<String> ext = new HashSet<String>();
        if (this.extensions != null && !this.extensions.isEmpty()) {
            ext.addAll(this.extensions);
        } else {
            ext.addAll(Arrays.stream(this.extension.split(",")).map(String::trim).collect(Collectors.toSet()));
        }
        try {
            AddExtensions addExtensions = new AddExtensions(quarkusProject).extensions(ext.stream().map(String::trim).collect(Collectors.toSet()));
            QuarkusCommandOutcome outcome = addExtensions.execute();
            if (!outcome.isSuccess()) {
                throw new MojoExecutionException("Unable to add extensions");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to update the pom.xml file", e);
        }
    }
}

