/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.quarkus.registry.catalog.PlatformImpl;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.json.JsonBuilder;
import java.util.Collection;
import java.util.Map;

public interface Platform {
    public String getPlatformKey();

    public String getName();

    public Collection<PlatformStream> getStreams();

    public Map<String, Object> getMetadata();

    public PlatformStream getStream(String var1);

    @JsonIgnore
    default public PlatformStream getRecommendedStream() {
        Collection<PlatformStream> streams = this.getStreams();
        if (streams.isEmpty()) {
            throw new RuntimeException("Platform " + this.getPlatformKey() + " does not include any stream");
        }
        return streams.iterator().next();
    }

    default public Mutable mutable() {
        return new PlatformImpl.Builder(this);
    }

    public static Mutable builder() {
        return new PlatformImpl.Builder();
    }

    public static interface Mutable
    extends Platform,
    JsonBuilder<Platform> {
        public Mutable setMetadata(Map<String, Object> var1);

        public Mutable setPlatformKey(String var1);

        public Mutable setName(String var1);

        public Mutable setStreams(Collection<PlatformStream> var1);

        public Mutable addStream(PlatformStream var1);

        @Override
        public Platform build();
    }
}

