/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.deployment.compose;

import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.PortBinding;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ComposeServiceDefinition {
    private final String serviceName;
    private final Map<String, ?> definitionMap;

    public ComposeServiceDefinition(String serviceName, Map<String, ?> definitionMap) {
        this.serviceName = serviceName;
        this.definitionMap = definitionMap;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getContainerName() {
        return (String)this.definitionMap.get("container_name");
    }

    public List<ExposedPort> getPorts() {
        List ports = (List)this.definitionMap.get("ports");
        if (ports == null) {
            return Collections.emptyList();
        }
        return ports.stream().map(port -> {
            String portString;
            if (port instanceof String) {
                portString = (String)port;
            } else if (port instanceof Map) {
                Map portMap = (Map)port;
                Object target = portMap.get("target");
                Object published = portMap.get("published");
                Object hostIp = portMap.get("host_ip");
                Object protocol = portMap.get("protocol");
                StringBuilder sb = new StringBuilder();
                if (hostIp != null) {
                    sb.append(hostIp).append(":");
                }
                if (published != null) {
                    String publishedStr = String.valueOf(published);
                    if (publishedStr.contains("-")) {
                        publishedStr = publishedStr.split("-")[0];
                    }
                    sb.append(publishedStr).append(":");
                }
                sb.append(target);
                if (protocol != null) {
                    sb.append("/").append(protocol);
                }
                portString = sb.toString();
            } else {
                throw new IllegalArgumentException("Unsupported port format: " + String.valueOf(port));
            }
            return PortBinding.parse((String)portString);
        }).map(PortBinding::getExposedPort).collect(Collectors.toList());
    }

    public boolean hasHealthCheck() {
        return this.definitionMap.get("healthcheck") instanceof Map;
    }

    public Map<String, Object> getLabels() {
        Object labels = this.definitionMap.get("labels");
        if (labels instanceof List) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Object label : (List)labels) {
                if (label instanceof String) {
                    String[] split = ((String)label).split("=");
                    map.put(split[0], split[1]);
                    continue;
                }
                if (!(label instanceof Map)) continue;
                map.putAll((Map)label);
            }
            return map;
        }
        if (labels instanceof Map) {
            return new HashMap<String, Object>((Map)labels);
        }
        return Collections.emptyMap();
    }

    public List<String> getProfiles() {
        Object profiles = this.definitionMap.get("profiles");
        if (profiles instanceof List) {
            return (List)profiles;
        }
        return Collections.emptyList();
    }
}

