/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl.constant;

import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.Util;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.smallrye.classfile.CodeBuilder;
import java.util.Objects;
import java.util.Optional;

public final class EnumConst
extends ConstImpl {
    private final Enum.EnumDesc<?> desc;
    private final int hashCode;

    public EnumConst(Enum.EnumDesc<?> desc) {
        super(desc.constantType());
        this.desc = desc;
        this.hashCode = Objects.hash(desc.constantName(), desc.constantType());
    }

    public String name() {
        return this.desc.constantName();
    }

    @Override
    public Enum.EnumDesc<?> desc() {
        return this.desc;
    }

    @Override
    public boolean isNonZero() {
        return true;
    }

    @Override
    public boolean equals(ConstImpl obj) {
        EnumConst other;
        return obj instanceof EnumConst && this.equals(other = (EnumConst)obj);
    }

    public boolean equals(EnumConst other) {
        return this == other || other != null && this.name().equals(other.name()) && this.type().equals(other.type());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        cb.getstatic(this.desc.constantType(), this.desc.constantName(), this.desc.constantType());
        smb.push(this.type());
        smb.wroteCode();
    }

    public Optional<Enum.EnumDesc<?>> describeConstable() {
        return Optional.of(this.desc());
    }

    @Override
    public StringBuilder toShortString(StringBuilder b) {
        return Util.descName(b, this.desc.constantType()).append('#').append(this.desc.constantName());
    }
}

