/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.TryFinally;
import io.quarkus.gizmo2.impl.Util;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.TypeKind;
import java.lang.constant.ClassDesc;
import java.lang.invoke.TypeDescriptor;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.BiConsumer;

final class Return
extends Item {
    static final Return RETURN_VOID = new Return(ConstImpl.ofVoid());
    private final Item returnValue;

    Return(Expr returnValue) {
        this.returnValue = (Item)returnValue;
    }

    @Override
    public boolean mayFallThrough() {
        return false;
    }

    @Override
    protected void forEachDependency(ListIterator<Item> itr, BiConsumer<Item, ListIterator<Item>> op) {
        this.returnValue.process(itr, op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl from, StackMapBuilder smb) {
        TryFinally tryFinally = from.tryFinally();
        ClassDesc returnType = from.returnType();
        if (tryFinally != null) {
            cb.goto_(tryFinally.cleanup(new ReturnKey(returnType, smb.save())));
            smb.wroteCode();
        } else {
            cb.return_(TypeKind.from((TypeDescriptor.OfField)returnType));
            smb.wroteCode();
        }
        if (!Util.isVoid(returnType)) {
            smb.pop();
        }
    }

    static final class ReturnKey
    extends TryFinally.CleanupKey {
        private final ClassDesc returnType;

        ReturnKey(ClassDesc returnType, StackMapBuilder.Saved saved) {
            super(saved);
            this.returnType = returnType;
        }

        @Override
        ClassDesc type() {
            return this.returnType;
        }

        @Override
        void terminate(BlockCreatorImpl bci, Expr input) {
            bci.return_(input);
        }

        public boolean equals(Object obj) {
            ReturnKey rk;
            return obj instanceof ReturnKey && this.equals(rk = (ReturnKey)obj);
        }

        public boolean equals(ReturnKey other) {
            return this == other || other != null && Util.equals(this.returnType, other.returnType);
        }

        public int hashCode() {
            return Objects.hash(ReturnKey.class, this.returnType);
        }
    }
}

