/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator;

import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.MemoryOrder;
import io.quarkus.gizmo2.SimpleTyped;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.AnonymousClassCreator;
import io.quarkus.gizmo2.creator.LambdaCreator;
import io.quarkus.gizmo2.creator.SwitchCreator;
import io.quarkus.gizmo2.creator.TryCreator;
import io.quarkus.gizmo2.creator.ops.ClassOps;
import io.quarkus.gizmo2.creator.ops.CollectionOps;
import io.quarkus.gizmo2.creator.ops.IteratorOps;
import io.quarkus.gizmo2.creator.ops.ListOps;
import io.quarkus.gizmo2.creator.ops.MapOps;
import io.quarkus.gizmo2.creator.ops.ObjectOps;
import io.quarkus.gizmo2.creator.ops.OptionalOps;
import io.quarkus.gizmo2.creator.ops.SetOps;
import io.quarkus.gizmo2.creator.ops.StringOps;
import io.quarkus.gizmo2.creator.ops.ThrowableOps;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.Descs;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicCallSiteDesc;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface BlockCreator
extends SimpleTyped {
    @Override
    public ClassDesc type();

    public void yield(Expr var1);

    default public void yieldNull() {
        this.yield(Const.ofNull(this.type()));
    }

    public boolean active();

    public boolean done();

    public boolean isContainedBy(BlockCreator var1);

    default public boolean contains(BlockCreator other) {
        return other.isContainedBy(this);
    }

    default public boolean contains(LocalVar var) {
        return this.contains(var.block());
    }

    public LocalVar localVar(String var1, GenericType var2, Expr var3);

    public LocalVar localVar(String var1, ClassDesc var2, Expr var3);

    default public LocalVar localVar(String name, Class<?> type, Expr value) {
        return this.localVar(name, Util.classDesc(type), value);
    }

    default public LocalVar localVar(String name, Expr value) {
        if (value.hasGenericType()) {
            return this.localVar(name, value.genericType(), value);
        }
        return this.localVar(name, value.type(), value);
    }

    default public LocalVar localVar(String name, boolean value) {
        return this.localVar(name, Const.of(value));
    }

    default public LocalVar localVar(String name, int value) {
        return this.localVar(name, Const.of(value));
    }

    default public LocalVar localVar(String name, long value) {
        return this.localVar(name, Const.of(value));
    }

    default public LocalVar localVar(String name, float value) {
        return this.localVar(name, Const.of(value));
    }

    default public LocalVar localVar(String name, double value) {
        return this.localVar(name, Const.of(value));
    }

    default public LocalVar localVar(String name, String value) {
        return this.localVar(name, Const.of(value));
    }

    default public LocalVar localVar(Var original) {
        return this.localVar(original.name(), original);
    }

    public Expr get(Assignable var1, MemoryOrder var2);

    default public Expr get(Assignable var) {
        return this.get(var, MemoryOrder.AsDeclared);
    }

    default public Expr getStaticField(FieldDesc desc) {
        return this.get(Expr.staticField(desc));
    }

    public void set(Assignable var1, Expr var2, MemoryOrder var3);

    default public void set(Assignable var, Expr value) {
        this.set(var, value, MemoryOrder.AsDeclared);
    }

    default public void set(Assignable var, Const value) {
        this.set(var, (Expr)value);
    }

    default public void set(Assignable var, ConstantDesc value) {
        this.set(var, Const.of(value));
    }

    default public void set(Assignable var, Constable value) {
        this.set(var, Const.of(value));
    }

    default public void set(Assignable var, String value) {
        this.set(var, Const.of(value));
    }

    default public void set(Assignable var, int value) {
        this.set(var, Const.of(value));
    }

    default public void set(Assignable var, long value) {
        this.set(var, Const.of(value));
    }

    default public void setStaticField(FieldDesc desc, Expr value) {
        this.set((Assignable)Expr.staticField(desc), value);
    }

    default public void swap(Assignable var1, Assignable var2) {
        Expr get1 = this.get(var1);
        this.set(var1, this.get(var2));
        this.set(var2, get1);
    }

    default public void rotate(Assignable var1, Assignable var2, Assignable var3) {
        Expr get1 = this.get(var1);
        this.set(var1, this.get(var3));
        this.set(var3, this.get(var2));
        this.set(var2, get1);
    }

    default public void rotate(Assignable var1, Assignable var2, Assignable var3, Assignable var4) {
        Expr get1 = this.get(var1);
        this.set(var1, this.get(var4));
        this.set(var4, this.get(var3));
        this.set(var3, this.get(var2));
        this.set(var2, get1);
    }

    public void inc(Assignable var1, Const var2);

    default public void inc(Assignable var, int amount) {
        this.inc(var, Const.of(amount, var.typeKind()));
    }

    default public void inc(Assignable var) {
        this.inc(var, 1);
    }

    public void dec(Assignable var1, Const var2);

    default public void dec(Assignable var, int amount) {
        this.dec(var, Const.of(amount, var.typeKind()));
    }

    default public void dec(Assignable var) {
        this.dec(var, 1);
    }

    public Expr compareAndSet(Assignable var1, Expr var2, Expr var3);

    public Expr weakCompareAndSet(Assignable var1, Expr var2, Expr var3, MemoryOrder var4);

    default public Expr weakCompareAndSet(Assignable var, Expr expected, Expr update) {
        return this.weakCompareAndSet(var, expected, update, MemoryOrder.Volatile);
    }

    public Expr compareAndExchange(Assignable var1, Expr var2, Expr var3, MemoryOrder var4);

    default public Expr compareAndExchange(Assignable var, Expr expected, Expr update) {
        return this.compareAndExchange(var, expected, update, MemoryOrder.Volatile);
    }

    public Expr getAndSet(Assignable var1, Expr var2, MemoryOrder var3);

    default public Expr getAndSet(Assignable var, Expr newValue) {
        return this.getAndSet(var, newValue, MemoryOrder.Volatile);
    }

    public Expr getAndAdd(Assignable var1, Expr var2, MemoryOrder var3);

    default public Expr getAndAdd(Assignable var, Expr amount) {
        return this.getAndAdd(var, amount, MemoryOrder.Volatile);
    }

    public Expr getAndBitwiseOr(Assignable var1, Expr var2, MemoryOrder var3);

    default public Expr getAndBitwiseOr(Assignable var, Expr other) {
        return this.getAndBitwiseOr(var, other, MemoryOrder.Volatile);
    }

    public Expr getAndBitwiseAnd(Assignable var1, Expr var2, MemoryOrder var3);

    default public Expr getAndBitwiseAnd(Assignable var, Expr other) {
        return this.getAndBitwiseAnd(var, other, MemoryOrder.Volatile);
    }

    public Expr getAndBitwiseXor(Assignable var1, Expr var2, MemoryOrder var3);

    default public Expr getAndBitwiseXor(Assignable var, Expr other) {
        return this.getAndBitwiseXor(var, other, MemoryOrder.Volatile);
    }

    default public void fullFence() {
        this.invokeStatic(Descs.MD_VarHandle.fullFence);
    }

    default public void acquireFence() {
        this.invokeStatic(Descs.MD_VarHandle.acquireFence);
    }

    default public void releaseFence() {
        this.invokeStatic(Descs.MD_VarHandle.releaseFence);
    }

    default public void loadLoadFence() {
        this.invokeStatic(Descs.MD_VarHandle.loadLoadFence);
    }

    default public void storeStoreFence() {
        this.invokeStatic(Descs.MD_VarHandle.storeStoreFence);
    }

    default public void reachabilityFence(Expr obj) {
        if (obj.typeKind() != TypeKind.REFERENCE) {
            throw new IllegalArgumentException("Reachability fence can only be emitted for reference types");
        }
        this.invokeStatic((MethodDesc)Descs.MD_Reference.reachabilityFence, obj);
    }

    public Expr newEmptyArray(ClassDesc var1, Expr var2);

    default public Expr newEmptyArray(ClassDesc componentType, int size) {
        return this.newEmptyArray(componentType, (Expr)Const.of(size));
    }

    default public Expr newEmptyArray(Class<?> componentType, Expr size) {
        return this.newEmptyArray(Util.classDesc(componentType), size);
    }

    default public Expr newEmptyArray(Class<?> componentType, int size) {
        return this.newEmptyArray(Util.classDesc(componentType), (Expr)Const.of(size));
    }

    public <T> Expr newArray(ClassDesc var1, List<T> var2, Function<T, ? extends Expr> var3);

    default public Expr newArray(ClassDesc componentType, List<? extends Expr> values) {
        return this.newArray(componentType, values, Function.identity());
    }

    default public Expr newArray(ClassDesc componentType, Expr ... values) {
        return this.newArray(componentType, List.of(values));
    }

    default public <T> Expr newArray(Class<?> componentType, List<T> values, Function<T, ? extends Expr> mapper) {
        return this.newArray(Util.classDesc(componentType), values, mapper);
    }

    default public Expr newArray(Class<?> componentType, List<? extends Expr> values) {
        return this.newArray(Util.classDesc(componentType), values);
    }

    default public Expr newArray(Class<?> componentType, Expr ... values) {
        return this.newArray(componentType, List.of(values));
    }

    default public Expr isNull(Expr input) {
        return this.eq(input, Const.ofNull(input.type()));
    }

    default public Expr isNotNull(Expr input) {
        return this.ne(input, Const.ofNull(input.type()));
    }

    public Expr eq(Expr var1, Expr var2);

    default public Expr eq(Expr a, int b) {
        return this.eq(a, Const.of(b, a.typeKind()));
    }

    default public Expr eq(Expr a, long b) {
        return this.eq(a, Const.of(b, a.typeKind()));
    }

    default public Expr eq(Expr a, float b) {
        return this.eq(a, Const.of(b, a.typeKind()));
    }

    default public Expr eq(Expr a, double b) {
        return this.eq(a, Const.of(b, a.typeKind()));
    }

    public Expr ne(Expr var1, Expr var2);

    default public Expr ne(Expr a, int b) {
        return this.ne(a, Const.of(b, a.typeKind()));
    }

    default public Expr ne(Expr a, long b) {
        return this.ne(a, Const.of(b, a.typeKind()));
    }

    default public Expr ne(Expr a, float b) {
        return this.ne(a, Const.of(b, a.typeKind()));
    }

    default public Expr ne(Expr a, double b) {
        return this.ne(a, Const.of(b, a.typeKind()));
    }

    public Expr lt(Expr var1, Expr var2);

    default public Expr lt(Expr a, int b) {
        return this.lt(a, Const.of(b, a.typeKind()));
    }

    default public Expr lt(Expr a, long b) {
        return this.lt(a, Const.of(b, a.typeKind()));
    }

    default public Expr lt(Expr a, float b) {
        return this.lt(a, Const.of(b, a.typeKind()));
    }

    default public Expr lt(Expr a, double b) {
        return this.lt(a, Const.of(b, a.typeKind()));
    }

    public Expr gt(Expr var1, Expr var2);

    default public Expr gt(Expr a, int b) {
        return this.gt(a, Const.of(b, a.typeKind()));
    }

    default public Expr gt(Expr a, long b) {
        return this.gt(a, Const.of(b, a.typeKind()));
    }

    default public Expr gt(Expr a, float b) {
        return this.gt(a, Const.of(b, a.typeKind()));
    }

    default public Expr gt(Expr a, double b) {
        return this.gt(a, Const.of(b, a.typeKind()));
    }

    public Expr le(Expr var1, Expr var2);

    default public Expr le(Expr a, int b) {
        return this.le(a, Const.of(b, a.typeKind()));
    }

    default public Expr le(Expr a, long b) {
        return this.le(a, Const.of(b, a.typeKind()));
    }

    default public Expr le(Expr a, float b) {
        return this.le(a, Const.of(b, a.typeKind()));
    }

    default public Expr le(Expr a, double b) {
        return this.le(a, Const.of(b, a.typeKind()));
    }

    public Expr ge(Expr var1, Expr var2);

    default public Expr ge(Expr a, int b) {
        return this.ge(a, Const.of(b, a.typeKind()));
    }

    default public Expr ge(Expr a, long b) {
        return this.ge(a, Const.of(b, a.typeKind()));
    }

    default public Expr ge(Expr a, float b) {
        return this.ge(a, Const.of(b, a.typeKind()));
    }

    default public Expr ge(Expr a, double b) {
        return this.ge(a, Const.of(b, a.typeKind()));
    }

    public Expr cmp(Expr var1, Expr var2);

    public Expr cmpl(Expr var1, Expr var2);

    public Expr cmpg(Expr var1, Expr var2);

    public Expr and(Expr var1, Expr var2);

    default public Expr and(Expr a, int b) {
        return this.and(a, Const.of(b, a.typeKind()));
    }

    default public Expr and(Expr a, long b) {
        return this.and(a, Const.of(b, a.typeKind()));
    }

    public Expr or(Expr var1, Expr var2);

    default public Expr or(Expr a, int b) {
        return this.or(a, Const.of(b, a.typeKind()));
    }

    default public Expr or(Expr a, long b) {
        return this.or(a, Const.of(b, a.typeKind()));
    }

    public Expr xor(Expr var1, Expr var2);

    default public Expr xor(Expr a, int b) {
        return this.xor(a, Const.of(b, a.typeKind()));
    }

    default public Expr xor(Expr a, long b) {
        return this.xor(a, Const.of(b, a.typeKind()));
    }

    public Expr complement(Expr var1);

    public Expr shl(Expr var1, Expr var2);

    default public Expr shl(Expr a, int b) {
        return this.shl(a, Const.of(b, a.typeKind()));
    }

    default public Expr shl(Expr a, long b) {
        return this.shl(a, Const.of(b, a.typeKind()));
    }

    public Expr shr(Expr var1, Expr var2);

    default public Expr shr(Expr a, int b) {
        return this.shr(a, Const.of(b, a.typeKind()));
    }

    default public Expr shr(Expr a, long b) {
        return this.shr(a, Const.of(b, a.typeKind()));
    }

    public Expr ushr(Expr var1, Expr var2);

    default public Expr ushr(Expr a, int b) {
        return this.ushr(a, Const.of(b, a.typeKind()));
    }

    default public Expr ushr(Expr a, long b) {
        return this.ushr(a, Const.of(b, a.typeKind()));
    }

    public Expr add(Expr var1, Expr var2);

    default public Expr add(Expr a, int b) {
        return this.add(a, Const.of(b, a.typeKind()));
    }

    default public Expr add(Expr a, long b) {
        return this.add(a, Const.of(b, a.typeKind()));
    }

    default public Expr add(Expr a, float b) {
        return this.add(a, Const.of(b, a.typeKind()));
    }

    default public Expr add(Expr a, double b) {
        return this.add(a, Const.of(b, a.typeKind()));
    }

    public Expr sub(Expr var1, Expr var2);

    default public Expr sub(Expr a, int b) {
        return this.sub(a, (Expr)Const.of(b, a.typeKind()));
    }

    default public Expr sub(Expr a, long b) {
        return this.sub(a, (Expr)Const.of(b, a.typeKind()));
    }

    default public Expr sub(Expr a, float b) {
        return this.sub(a, (Expr)Const.of(b, a.typeKind()));
    }

    default public Expr sub(Expr a, double b) {
        return this.sub(a, (Expr)Const.of(b, a.typeKind()));
    }

    default public Expr sub(int a, Expr b) {
        return this.sub((Expr)Const.of(a, b.typeKind()), b);
    }

    default public Expr sub(long a, Expr b) {
        return this.sub((Expr)Const.of(a, b.typeKind()), b);
    }

    default public Expr sub(float a, Expr b) {
        return this.sub((Expr)Const.of(a, b.typeKind()), b);
    }

    default public Expr sub(double a, Expr b) {
        return this.sub((Expr)Const.of(a, b.typeKind()), b);
    }

    public Expr mul(Expr var1, Expr var2);

    default public Expr mul(Expr a, int b) {
        return this.mul(a, Const.of(b, a.typeKind()));
    }

    default public Expr mul(Expr a, long b) {
        return this.mul(a, Const.of(b, a.typeKind()));
    }

    default public Expr mul(Expr a, float b) {
        return this.mul(a, Const.of(b, a.typeKind()));
    }

    default public Expr mul(Expr a, double b) {
        return this.mul(a, Const.of(b, a.typeKind()));
    }

    public Expr div(Expr var1, Expr var2);

    default public Expr div(Expr a, int b) {
        return this.div(a, (Expr)Const.of(b, a.typeKind()));
    }

    default public Expr div(Expr a, long b) {
        return this.div(a, (Expr)Const.of(b, a.typeKind()));
    }

    default public Expr div(Expr a, float b) {
        return this.div(a, (Expr)Const.of(b, a.typeKind()));
    }

    default public Expr div(Expr a, double b) {
        return this.div(a, (Expr)Const.of(b, a.typeKind()));
    }

    default public Expr div(int a, Expr b) {
        return this.div((Expr)Const.of(a, b.typeKind()), b);
    }

    default public Expr div(long a, Expr b) {
        return this.div((Expr)Const.of(a, b.typeKind()), b);
    }

    default public Expr div(float a, Expr b) {
        return this.div((Expr)Const.of(a, b.typeKind()), b);
    }

    default public Expr div(double a, Expr b) {
        return this.div((Expr)Const.of(a, b.typeKind()), b);
    }

    public Expr rem(Expr var1, Expr var2);

    default public Expr rem(Expr a, int b) {
        return this.rem(a, (Expr)Const.of(b, a.typeKind()));
    }

    default public Expr rem(Expr a, long b) {
        return this.rem(a, (Expr)Const.of(b, a.typeKind()));
    }

    default public Expr rem(Expr a, float b) {
        return this.rem(a, (Expr)Const.of(b, a.typeKind()));
    }

    default public Expr rem(Expr a, double b) {
        return this.rem(a, (Expr)Const.of(b, a.typeKind()));
    }

    default public Expr rem(int a, Expr b) {
        return this.rem((Expr)Const.of(a, b.typeKind()), b);
    }

    default public Expr rem(long a, Expr b) {
        return this.rem((Expr)Const.of(a, b.typeKind()), b);
    }

    default public Expr rem(float a, Expr b) {
        return this.rem((Expr)Const.of(a, b.typeKind()), b);
    }

    default public Expr rem(double a, Expr b) {
        return this.rem((Expr)Const.of(a, b.typeKind()), b);
    }

    public Expr neg(Expr var1);

    public void addAssign(Assignable var1, Expr var2);

    public void subAssign(Assignable var1, Expr var2);

    public void mulAssign(Assignable var1, Expr var2);

    public void divAssign(Assignable var1, Expr var2);

    public void remAssign(Assignable var1, Expr var2);

    public void andAssign(Assignable var1, Expr var2);

    public void orAssign(Assignable var1, Expr var2);

    public void xorAssign(Assignable var1, Expr var2);

    public void shlAssign(Assignable var1, Expr var2);

    public void shrAssign(Assignable var1, Expr var2);

    public void ushrAssign(Assignable var1, Expr var2);

    default public Expr logicalNot(Expr a) {
        return a.typeKind() == TypeKind.BOOLEAN ? this.xor(a, Const.of(1)) : this.eq(a, Const.of(0, a.typeKind()));
    }

    default public Expr logicalOr(Expr cond, Consumer<BlockCreator> other) {
        return this.cond(ConstantDescs.CD_boolean, cond, (BlockCreator bc) -> bc.yield(Const.of(true)), other);
    }

    default public Expr logicalAnd(Expr cond, Consumer<BlockCreator> other) {
        return this.cond(ConstantDescs.CD_boolean, cond, other, (BlockCreator bc) -> bc.yield(Const.of(false)));
    }

    default public Expr cond(Class<?> type, Expr cond, Consumer<BlockCreator> ifTrue, Consumer<BlockCreator> ifFalse) {
        return this.cond(Util.classDesc(type), cond, ifTrue, ifFalse);
    }

    public Expr cond(ClassDesc var1, Expr var2, Consumer<BlockCreator> var3, Consumer<BlockCreator> var4);

    default public Expr lambda(Class<?> type, Consumer<LambdaCreator> builder) {
        return this.lambda(Util.findSam(type), Util.classDesc(type), builder);
    }

    default public Expr lambda(MethodDesc sam, Consumer<LambdaCreator> builder) {
        return this.lambda(sam, sam.owner(), builder);
    }

    public Expr lambda(MethodDesc var1, ClassDesc var2, Consumer<LambdaCreator> var3);

    public Expr newAnonymousClass(ConstructorDesc var1, List<? extends Expr> var2, Consumer<AnonymousClassCreator> var3);

    default public Expr newAnonymousClass(ClassDesc interface_, Consumer<AnonymousClassCreator> builder) {
        return this.newAnonymousClass(ConstructorDesc.of(Object.class, new Class[0]), List.of(), cc -> {
            cc.implements_(interface_);
            builder.accept((AnonymousClassCreator)cc);
        });
    }

    default public Expr newAnonymousClass(Class<?> supertype, Consumer<AnonymousClassCreator> builder) {
        if (supertype.isInterface()) {
            return this.newAnonymousClass(Util.classDesc(supertype), builder);
        }
        ConstructorDesc superCtor = ConstructorDesc.of(supertype, new Class[0]);
        return this.newAnonymousClass(superCtor, List.of(), builder);
    }

    public Expr cast(Expr var1, GenericType var2);

    public Expr cast(Expr var1, ClassDesc var2);

    default public Expr cast(Expr a, Class<?> toType) {
        return this.cast(a, Util.classDesc(toType));
    }

    public Expr uncheckedCast(Expr var1, GenericType var2);

    public Expr uncheckedCast(Expr var1, ClassDesc var2);

    default public Expr uncheckedCast(Expr a, Class<?> toType) {
        return this.uncheckedCast(a, Util.classDesc(toType));
    }

    public Expr box(Expr var1);

    public Expr unbox(Expr var1);

    default public Expr instanceOf(Expr obj, Class<?> type) {
        return this.instanceOf(obj, Util.classDesc(type));
    }

    public Expr instanceOf(Expr var1, ClassDesc var2);

    public Expr instanceOf(Expr var1, GenericType var2);

    public Expr new_(GenericType var1, ConstructorDesc var2, List<? extends Expr> var3);

    public Expr new_(ConstructorDesc var1, List<? extends Expr> var2);

    default public Expr new_(ConstructorDesc ctor) {
        return this.new_(ctor, List.of());
    }

    default public Expr new_(ConstructorDesc ctor, Expr arg0) {
        return this.new_(ctor, List.of(arg0));
    }

    default public Expr new_(ConstructorDesc ctor, Expr arg0, Expr arg1) {
        return this.new_(ctor, List.of(arg0, arg1));
    }

    default public Expr new_(ConstructorDesc ctor, Expr ... args) {
        return this.new_(ctor, List.of(args));
    }

    default public Expr new_(ClassDesc type, List<? extends Expr> args) {
        return this.new_(ConstructorDesc.of(type, args.stream().map(Expr::type).toList()), args);
    }

    default public Expr new_(ClassDesc type) {
        return this.new_(type, List.of());
    }

    default public Expr new_(ClassDesc type, Expr arg0) {
        return this.new_(type, List.of(arg0));
    }

    default public Expr new_(ClassDesc type, Expr arg0, Expr arg1) {
        return this.new_(type, List.of(arg0, arg1));
    }

    default public Expr new_(ClassDesc type, Expr ... args) {
        return this.new_(type, List.of(args));
    }

    default public Expr new_(GenericType type, List<? extends Expr> args) {
        return this.new_(ConstructorDesc.of(type.desc(), args.stream().map(Expr::type).toList()), args);
    }

    default public Expr new_(GenericType type) {
        return this.new_(type, List.of());
    }

    default public Expr new_(GenericType type, Expr arg0) {
        return this.new_(type, List.of(arg0));
    }

    default public Expr new_(GenericType type, Expr arg0, Expr arg1) {
        return this.new_(type, List.of(arg0, arg1));
    }

    default public Expr new_(GenericType type, Expr ... args) {
        return this.new_(type, List.of(args));
    }

    default public Expr new_(Class<?> type, List<? extends Expr> args) {
        return this.new_(Util.classDesc(type), args);
    }

    default public Expr new_(Class<?> type) {
        return this.new_(type, List.of());
    }

    default public Expr new_(Class<?> type, Expr arg0) {
        return this.new_(type, List.of(arg0));
    }

    default public Expr new_(Class<?> type, Expr arg0, Expr arg1) {
        return this.new_(type, List.of(arg0, arg1));
    }

    default public Expr new_(Class<?> type, Expr ... args) {
        return this.new_(type, List.of(args));
    }

    public Expr invokeStatic(GenericType var1, MethodDesc var2, List<? extends Expr> var3);

    public Expr invokeStatic(MethodDesc var1, List<? extends Expr> var2);

    default public Expr invokeStatic(MethodDesc method) {
        return this.invokeStatic(method, List.of());
    }

    default public Expr invokeStatic(MethodDesc method, Expr arg0) {
        return this.invokeStatic(method, List.of(arg0));
    }

    default public Expr invokeStatic(MethodDesc method, Expr arg0, Expr arg1) {
        return this.invokeStatic(method, List.of(arg0, arg1));
    }

    default public Expr invokeStatic(MethodDesc method, Expr ... args) {
        return this.invokeStatic(method, List.of(args));
    }

    public Expr invokeVirtual(GenericType var1, MethodDesc var2, Expr var3, List<? extends Expr> var4);

    public Expr invokeVirtual(MethodDesc var1, Expr var2, List<? extends Expr> var3);

    default public Expr invokeVirtual(MethodDesc method, Expr instance) {
        return this.invokeVirtual(method, instance, List.of());
    }

    default public Expr invokeVirtual(MethodDesc method, Expr instance, Expr arg0) {
        return this.invokeVirtual(method, instance, List.of(arg0));
    }

    default public Expr invokeVirtual(MethodDesc method, Expr instance, Expr arg0, Expr arg1) {
        return this.invokeVirtual(method, instance, List.of(arg0, arg1));
    }

    default public Expr invokeVirtual(MethodDesc method, Expr instance, Expr ... args) {
        return this.invokeVirtual(method, instance, List.of(args));
    }

    public Expr invokeSpecial(GenericType var1, MethodDesc var2, Expr var3, List<? extends Expr> var4);

    public Expr invokeSpecial(MethodDesc var1, Expr var2, List<? extends Expr> var3);

    default public Expr invokeSpecial(MethodDesc method, Expr instance) {
        return this.invokeSpecial(method, instance, List.of());
    }

    default public Expr invokeSpecial(MethodDesc method, Expr instance, Expr arg0) {
        return this.invokeSpecial(method, instance, List.of(arg0));
    }

    default public Expr invokeSpecial(MethodDesc method, Expr instance, Expr arg0, Expr arg1) {
        return this.invokeSpecial(method, instance, List.of(arg0, arg1));
    }

    default public Expr invokeSpecial(MethodDesc method, Expr instance, Expr ... args) {
        return this.invokeSpecial(method, instance, List.of(args));
    }

    public Expr invokeSpecial(ConstructorDesc var1, Expr var2, List<? extends Expr> var3);

    default public Expr invokeSpecial(ConstructorDesc ctor, Expr instance) {
        return this.invokeSpecial(ctor, instance, List.of());
    }

    default public Expr invokeSpecial(ConstructorDesc ctor, Expr instance, Expr arg0) {
        return this.invokeSpecial(ctor, instance, List.of(arg0));
    }

    default public Expr invokeSpecial(ConstructorDesc ctor, Expr instance, Expr arg0, Expr arg1) {
        return this.invokeSpecial(ctor, instance, List.of(arg0, arg1));
    }

    default public Expr invokeSpecial(ConstructorDesc ctor, Expr instance, Expr ... args) {
        return this.invokeSpecial(ctor, instance, List.of(args));
    }

    public Expr invokeInterface(GenericType var1, MethodDesc var2, Expr var3, List<? extends Expr> var4);

    public Expr invokeInterface(MethodDesc var1, Expr var2, List<? extends Expr> var3);

    default public Expr invokeInterface(MethodDesc method, Expr instance) {
        return this.invokeInterface(method, instance, List.of());
    }

    default public Expr invokeInterface(MethodDesc method, Expr instance, Expr arg0) {
        return this.invokeInterface(method, instance, List.of(arg0));
    }

    default public Expr invokeInterface(MethodDesc method, Expr instance, Expr arg0, Expr arg1) {
        return this.invokeInterface(method, instance, List.of(arg0, arg1));
    }

    default public Expr invokeInterface(MethodDesc method, Expr instance, Expr ... args) {
        return this.invokeInterface(method, instance, List.of(args));
    }

    public Expr invokeDynamic(DynamicCallSiteDesc var1, List<? extends Expr> var2);

    default public Expr invokeDynamic(DynamicCallSiteDesc callSiteDesc, Expr ... args) {
        return this.invokeDynamic(callSiteDesc, List.of(args));
    }

    public void forEach(Expr var1, BiConsumer<BlockCreator, ? super LocalVar> var2);

    public void block(Consumer<BlockCreator> var1);

    public Expr blockExpr(ClassDesc var1, Consumer<BlockCreator> var2);

    default public Expr blockExpr(Class<?> type, Consumer<BlockCreator> nested) {
        return this.blockExpr(Util.classDesc(type), nested);
    }

    default public void ifInstanceOf(Expr obj, Class<?> type, BiConsumer<BlockCreator, ? super LocalVar> ifTrue) {
        this.ifInstanceOf(obj, Util.classDesc(type), ifTrue);
    }

    public void ifInstanceOf(Expr var1, ClassDesc var2, BiConsumer<BlockCreator, ? super LocalVar> var3);

    default public void ifNotInstanceOf(Expr obj, Class<?> type, Consumer<BlockCreator> ifFalse) {
        this.ifNotInstanceOf(obj, Util.classDesc(type), ifFalse);
    }

    public void ifNotInstanceOf(Expr var1, ClassDesc var2, Consumer<BlockCreator> var3);

    default public void ifInstanceOfElse(Expr obj, Class<?> type, BiConsumer<BlockCreator, ? super LocalVar> ifTrue, Consumer<BlockCreator> ifFalse) {
        this.ifInstanceOfElse(obj, Util.classDesc(type), ifTrue, ifFalse);
    }

    public void ifInstanceOfElse(Expr var1, ClassDesc var2, BiConsumer<BlockCreator, ? super LocalVar> var3, Consumer<BlockCreator> var4);

    public void if_(Expr var1, Consumer<BlockCreator> var2);

    public void ifNot(Expr var1, Consumer<BlockCreator> var2);

    public void ifElse(Expr var1, Consumer<BlockCreator> var2, Consumer<BlockCreator> var3);

    default public void ifNull(Expr obj, Consumer<BlockCreator> whenTrue) {
        this.if_(this.eq(obj, Const.ofNull(obj.type())), whenTrue);
    }

    default public void ifNotNull(Expr obj, Consumer<BlockCreator> whenTrue) {
        this.if_(this.ne(obj, Const.ofNull(obj.type())), whenTrue);
    }

    default public void switchEnum(Expr val, Consumer<SwitchCreator> builder) {
        this.switchEnum(ConstantDescs.CD_void, val, builder);
    }

    public Expr switchEnum(ClassDesc var1, Expr var2, Consumer<SwitchCreator> var3);

    default public Expr switchEnum(Class<?> outputType, Expr val, Consumer<SwitchCreator> builder) {
        return this.switchEnum(Util.classDesc(outputType), val, builder);
    }

    default public void switch_(Expr val, Consumer<SwitchCreator> builder) {
        this.switch_(ConstantDescs.CD_void, val, builder);
    }

    public Expr switch_(ClassDesc var1, Expr var2, Consumer<SwitchCreator> var3);

    default public Expr switch_(Class<?> outputType, Expr val, Consumer<SwitchCreator> builder) {
        return this.switch_(Util.classDesc(outputType), val, builder);
    }

    public void break_(BlockCreator var1);

    public void continue_(BlockCreator var1);

    public void goto_(BlockCreator var1);

    default public void gotoStart() {
        this.goto_(this);
    }

    public void gotoCase(SwitchCreator var1, Const var2);

    default public void gotoCase(SwitchCreator switch_, int case_) {
        this.gotoCase(switch_, Const.of(case_));
    }

    default public void gotoCase(SwitchCreator switch_, String case_) {
        this.gotoCase(switch_, Const.of(case_));
    }

    default public void gotoCase(SwitchCreator switch_, Enum<?> case_) {
        this.gotoCase(switch_, Const.of(case_));
    }

    default public void gotoCase(SwitchCreator switch_, Class<?> case_) {
        this.gotoCase(switch_, Const.of(case_));
    }

    public void gotoDefault(SwitchCreator var1);

    public void loop(Consumer<BlockCreator> var1);

    public void while_(Consumer<BlockCreator> var1, Consumer<BlockCreator> var2);

    public void doWhile(Consumer<BlockCreator> var1, Consumer<BlockCreator> var2);

    public void try_(Consumer<TryCreator> var1);

    public void autoClose(Expr var1, BiConsumer<BlockCreator, ? super LocalVar> var2);

    public void autoClose(LocalVar var1, Consumer<BlockCreator> var2);

    public void synchronized_(Expr var1, Consumer<BlockCreator> var2);

    public void locked(Expr var1, Consumer<BlockCreator> var2);

    public void return_();

    public void return_(Expr var1);

    default public void return_(String val) {
        this.return_(Const.of(val));
    }

    default public void return_(Class<?> val) {
        this.return_(Const.of(val));
    }

    default public void return_(boolean val) {
        this.return_(Const.of(val));
    }

    default public void return_(int val) {
        this.return_(Const.of(val));
    }

    default public void returnTrue() {
        this.return_(true);
    }

    default public void returnFalse() {
        this.return_(false);
    }

    default public void returnIntZero() {
        this.return_(Const.of(0));
    }

    public void returnNull();

    public void throw_(Expr var1);

    default public void throw_(ClassDesc type) {
        this.throw_(this.new_(type));
    }

    default public void throw_(ClassDesc type, String message) {
        this.throw_(this.new_(type, (Expr)Const.of(message)));
    }

    default public void throw_(ClassDesc type, Expr message) {
        this.throw_(this.new_(type, message));
    }

    default public void throw_(Class<? extends Throwable> type) {
        this.throw_(Util.classDesc(type));
    }

    default public void throw_(Class<? extends Throwable> type, String message) {
        if (message == null) {
            this.throw_(type);
        } else {
            this.throw_(Util.classDesc(type), message);
        }
    }

    default public void throw_(Class<? extends Throwable> type, Expr message) {
        if (message == null) {
            this.throw_(type);
        } else {
            this.throw_(Util.classDesc(type), message);
        }
    }

    public Expr objHashCode(Expr var1);

    public Expr objEquals(Expr var1, Expr var2);

    public Expr objToString(Expr var1);

    public Expr arrayHashCode(Expr var1);

    public Expr arrayEquals(Expr var1, Expr var2);

    public Expr arrayToString(Expr var1);

    default public ObjectOps withObject(Expr receiver) {
        return new ObjectOps(this, receiver);
    }

    default public ClassOps withClass(Expr receiver) {
        return new ClassOps(this, receiver);
    }

    default public StringOps withString(Expr receiver) {
        return new StringOps(this, receiver);
    }

    default public CollectionOps withCollection(Expr receiver) {
        return new CollectionOps(this, receiver);
    }

    default public ListOps withList(Expr receiver) {
        return new ListOps(this, receiver);
    }

    default public SetOps withSet(Expr receiver) {
        return new SetOps(this, receiver);
    }

    default public MapOps withMap(Expr receiver) {
        return new MapOps(this, receiver);
    }

    default public IteratorOps withIterator(Expr receiver) {
        return new IteratorOps(this, receiver);
    }

    default public OptionalOps withOptional(Expr receiver) {
        return new OptionalOps(this, receiver);
    }

    default public ThrowableOps withThrowable(Expr throwable) {
        return new ThrowableOps(this, throwable);
    }

    public Expr classForName(Expr var1);

    public <T> Expr listOf(List<T> var1, Function<T, ? extends Expr> var2);

    default public Expr listOf(List<? extends Expr> items) {
        return this.listOf(items, Function.identity());
    }

    default public Expr listOf(Expr ... items) {
        return this.listOf(List.of(items));
    }

    public <T> Expr setOf(List<T> var1, Function<T, ? extends Expr> var2);

    default public Expr setOf(List<? extends Expr> items) {
        return this.setOf(items, Function.identity());
    }

    default public Expr setOf(Expr ... items) {
        return this.setOf(List.of(items));
    }

    public Expr mapOf(List<? extends Expr> var1);

    default public Expr mapOf(Expr ... items) {
        return this.mapOf(List.of(items));
    }

    public Expr mapEntry(Expr var1, Expr var2);

    public Expr optionalOf(Expr var1);

    public Expr optionalOfNullable(Expr var1);

    public Expr iterate(Expr var1);

    public Expr currentThread();

    public void close(Expr var1);

    public void line(int var1);

    public void printf(String var1, List<? extends Expr> var2);

    default public void printf(String format, Expr ... values) {
        this.printf(format, List.of(values));
    }

    public void assert_(Consumer<BlockCreator> var1, String var2);
}

