/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.jooq.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkiverse.jooq.runtime.JooqCustomContext;
import javax.sql.DataSource;
import org.jboss.logging.Logger;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;

public class DslContextFactory {
    private static final Logger log = Logger.getLogger(DslContextFactory.class);

    public static DSLContext create(String sqlDialect, AgroalDataSource ds, JooqCustomContext customContext) {
        DSLContext context;
        if ("PostgreSQL".equalsIgnoreCase(sqlDialect) || "Postgres".equalsIgnoreCase(sqlDialect)) {
            context = DSL.using((DataSource)ds, (SQLDialect)SQLDialect.POSTGRES);
        } else if ("MySQL".equalsIgnoreCase(sqlDialect)) {
            context = DSL.using((DataSource)ds, (SQLDialect)SQLDialect.MYSQL);
        } else if ("MARIADB".equalsIgnoreCase(sqlDialect)) {
            context = DSL.using((DataSource)ds, (SQLDialect)SQLDialect.MARIADB);
        } else if ("Oracle".equalsIgnoreCase(sqlDialect)) {
            context = DSL.using((DataSource)ds, (SQLDialect)SQLDialect.DEFAULT);
        } else if ("SQLServer".equalsIgnoreCase(sqlDialect)) {
            context = DSL.using((DataSource)ds, (SQLDialect)SQLDialect.DEFAULT);
        } else if ("DB2".equalsIgnoreCase(sqlDialect)) {
            context = DSL.using((DataSource)ds, (SQLDialect)SQLDialect.DEFAULT);
        } else if ("Derby".equalsIgnoreCase(sqlDialect)) {
            context = DSL.using((DataSource)ds, (SQLDialect)SQLDialect.DERBY);
        } else if ("HSQLDB".equalsIgnoreCase(sqlDialect)) {
            context = DSL.using((DataSource)ds, (SQLDialect)SQLDialect.HSQLDB);
        } else if ("H2".equalsIgnoreCase(sqlDialect)) {
            context = DSL.using((DataSource)ds, (SQLDialect)SQLDialect.H2);
        } else if ("Firebird".equalsIgnoreCase(sqlDialect)) {
            context = DSL.using((DataSource)ds, (SQLDialect)SQLDialect.FIREBIRD);
        } else if ("SQLite".equalsIgnoreCase(sqlDialect)) {
            context = DSL.using((DataSource)ds, (SQLDialect)SQLDialect.SQLITE);
        } else {
            log.warnv("Undefined sqlDialect: {0}", (Object)sqlDialect);
            context = DSL.using((DataSource)ds, (SQLDialect)SQLDialect.DEFAULT);
        }
        customContext.apply(context.configuration());
        return context;
    }

    static {
        System.setProperty("org.jooq.no-logo", String.valueOf(true));
    }
}

