/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.transport;

import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.micrometer.shaded.io.netty.channel.ChannelPipeline;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.logging.LogLevel;
import io.micrometer.shaded.io.netty.handler.logging.LoggingHandler;
import io.micrometer.shaded.io.netty.handler.proxy.HttpProxyHandler;
import io.micrometer.shaded.io.netty.handler.proxy.ProxyHandler;
import io.micrometer.shaded.io.netty.handler.proxy.Socks4ProxyHandler;
import io.micrometer.shaded.io.netty.handler.proxy.Socks5ProxyHandler;
import io.micrometer.shaded.io.netty.util.internal.StringUtil;
import io.micrometer.shaded.reactor.netty.transport.AddressUtils;
import io.micrometer.shaded.reactor.netty.transport.logging.AdvancedByteBufFormat;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class ProxyProvider {
    final String username;
    final Function<? super String, ? extends String> password;
    final Supplier<? extends InetSocketAddress> address;
    final Predicate<SocketAddress> nonProxyHostPredicate;
    final Supplier<? extends HttpHeaders> httpHeaders;
    final Proxy type;
    final long connectTimeoutMillis;
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler("io.micrometer.shaded.reactor.netty.proxy", LogLevel.DEBUG, Charset.defaultCharset());
    static final String HTTP_PROXY_HOST = "http.proxyHost";
    static final String HTTP_PROXY_PORT = "http.proxyPort";
    static final String HTTP_PROXY_USER = "http.proxyUser";
    static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    static final String HTTPS_PROXY_HOST = "https.proxyHost";
    static final String HTTPS_PROXY_PORT = "https.proxyPort";
    static final String HTTPS_PROXY_USER = "https.proxyUser";
    static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    static final String DEFAULT_NON_PROXY_HOSTS = "localhost|127.*|[::1]";
    static final String SOCKS_PROXY_HOST = "socksProxyHost";
    static final String SOCKS_PROXY_PORT = "socksProxyPort";
    static final String SOCKS_VERSION = "socksProxyVersion";
    static final String SOCKS_VERSION_5 = "5";
    static final String SOCKS_VERSION_4 = "4";
    static final String SOCKS_USERNAME = "java.net.socks.username";
    static final String SOCKS_PASSWORD = "java.net.socks.password";

    public static TypeSpec builder() {
        return new Build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ProxyProvider(Build builder) {
        this.username = builder.username;
        this.password = builder.password;
        this.nonProxyHostPredicate = builder.nonProxyHostPredicate;
        if (Objects.isNull(builder.address)) {
            if (builder.host == null) throw new IllegalArgumentException("Neither address nor host is specified");
            this.address = () -> AddressUtils.createResolved(builder.host, builder.port);
        } else {
            this.address = builder.address;
        }
        this.httpHeaders = builder.httpHeaders;
        this.type = builder.type;
        this.connectTimeoutMillis = builder.connectTimeoutMillis;
    }

    public final Proxy getType() {
        return this.type;
    }

    public final Supplier<? extends InetSocketAddress> getAddress() {
        return this.address;
    }

    public final Predicate<SocketAddress> getNonProxyHostsPredicate() {
        return this.nonProxyHostPredicate;
    }

    public final ProxyHandler newProxyHandler() {
        ProxyHandler proxyHandler;
        InetSocketAddress proxyAddr = this.address.get();
        boolean b = Objects.nonNull(this.username) && Objects.nonNull(this.password);
        String username = this.username;
        String password = b ? this.password.apply(username) : null;
        switch (this.type) {
            case HTTP: {
                proxyHandler = b ? new HttpProxyHandler(proxyAddr, username, password, this.httpHeaders.get()) : new HttpProxyHandler(proxyAddr, this.httpHeaders.get());
                break;
            }
            case SOCKS4: {
                proxyHandler = Objects.nonNull(username) ? new Socks4ProxyHandler(proxyAddr, username) : new Socks4ProxyHandler(proxyAddr);
                break;
            }
            case SOCKS5: {
                proxyHandler = b ? new Socks5ProxyHandler(proxyAddr, username, password) : new Socks5ProxyHandler(proxyAddr);
                break;
            }
            default: {
                throw new IllegalArgumentException("Proxy type unsupported : " + (Object)((Object)this.type));
            }
        }
        proxyHandler.setConnectTimeoutMillis(this.connectTimeoutMillis);
        return proxyHandler;
    }

    public boolean shouldProxy(SocketAddress address) {
        return address instanceof InetSocketAddress && !this.nonProxyHostPredicate.test(address);
    }

    public void addProxyHandler(Channel channel) {
        Objects.requireNonNull(channel, "channel");
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst("io.micrometer.shaded.reactor.left.proxyHandler", (ChannelHandler)this.newProxyHandler());
        if (this.type == Proxy.SOCKS4 || this.type == Proxy.SOCKS5) {
            pipeline.addAfter("io.micrometer.shaded.reactor.left.proxyHandler", "io.micrometer.shaded.reactor.left.unvoidHandler", UnvoidHandler.INSTANCE);
        }
        if (pipeline.get("io.micrometer.shaded.reactor.left.loggingHandler") != null) {
            pipeline.addBefore("io.micrometer.shaded.reactor.left.proxyHandler", "io.micrometer.shaded.reactor.left.proxyLoggingHandler", LOGGING_HANDLER);
        }
    }

    public String toString() {
        return "ProxyProvider {address=" + this.address.get() + ", nonProxyHosts=" + this.nonProxyHostPredicate + ", type=" + (Object)((Object)this.type) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyProvider that = (ProxyProvider)o;
        return Objects.equals(this.username, that.username) && Objects.equals(this.getPasswordValue(), that.getPasswordValue()) && Objects.equals(this.getAddress().get(), that.getAddress().get()) && this.getNonProxyHostsValue() == that.getNonProxyHostsValue() && Objects.equals(this.httpHeaders.get(), that.httpHeaders.get()) && this.getType() == that.getType() && this.connectTimeoutMillis == that.connectTimeoutMillis;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.username);
        result = 31 * result + Objects.hashCode(this.getPasswordValue());
        result = 31 * result + Objects.hashCode(this.getAddress().get());
        result = 31 * result + Boolean.hashCode(this.getNonProxyHostsValue());
        result = 31 * result + Objects.hashCode(this.httpHeaders.get());
        result = 31 * result + Objects.hashCode((Object)this.getType());
        result = 31 * result + Long.hashCode(this.connectTimeoutMillis);
        return result;
    }

    private boolean getNonProxyHostsValue() {
        return this.nonProxyHostPredicate.test(this.getAddress().get());
    }

    @Nullable
    private String getPasswordValue() {
        if (this.username == null || this.password == null) {
            return null;
        }
        return this.password.apply(this.username);
    }

    @Nullable
    static ProxyProvider createFrom(Properties properties) {
        Objects.requireNonNull(properties, "properties");
        if (properties.containsKey(HTTP_PROXY_HOST) || properties.containsKey(HTTPS_PROXY_HOST)) {
            return ProxyProvider.createHttpProxyFrom(properties);
        }
        if (properties.containsKey(SOCKS_PROXY_HOST)) {
            return ProxyProvider.createSocksProxyFrom(properties);
        }
        return null;
    }

    static ProxyProvider createHttpProxyFrom(Properties properties) {
        String defaultPort;
        String passwordProperty;
        String userProperty;
        String portProperty;
        String hostProperty;
        if (properties.containsKey(HTTPS_PROXY_HOST)) {
            hostProperty = HTTPS_PROXY_HOST;
            portProperty = HTTPS_PROXY_PORT;
            userProperty = HTTPS_PROXY_USER;
            passwordProperty = HTTPS_PROXY_PASSWORD;
            defaultPort = "443";
        } else {
            hostProperty = HTTP_PROXY_HOST;
            portProperty = HTTP_PROXY_PORT;
            userProperty = HTTP_PROXY_USER;
            passwordProperty = HTTP_PROXY_PASSWORD;
            defaultPort = "80";
        }
        String hostname = Objects.requireNonNull(properties.getProperty(hostProperty), hostProperty);
        int port = ProxyProvider.parsePort(properties.getProperty(portProperty, defaultPort), portProperty);
        String nonProxyHosts = properties.getProperty(HTTP_NON_PROXY_HOSTS, DEFAULT_NON_PROXY_HOSTS);
        RegexShouldProxyPredicate transformedNonProxyHosts = RegexShouldProxyPredicate.fromWildcardedPattern(nonProxyHosts);
        Builder proxy = ProxyProvider.builder().type(Proxy.HTTP).host(hostname).port(port).nonProxyHostsPredicate(transformedNonProxyHosts);
        if (properties.containsKey(userProperty)) {
            proxy = proxy.username(properties.getProperty(userProperty));
            if (properties.containsKey(passwordProperty)) {
                proxy = proxy.password(u -> properties.getProperty(passwordProperty));
            } else {
                throw new NullPointerException("Proxy username is set via '" + userProperty + "', but '" + passwordProperty + "' is not set.");
            }
        }
        return proxy.build();
    }

    static ProxyProvider createSocksProxyFrom(Properties properties) {
        String hostname = Objects.requireNonNull(properties.getProperty(SOCKS_PROXY_HOST), SOCKS_PROXY_HOST);
        String version = properties.getProperty(SOCKS_VERSION, SOCKS_VERSION_5);
        if (!SOCKS_VERSION_5.equals(version) && !SOCKS_VERSION_4.equals(version)) {
            String message = "only socks versions 4 and 5 supported but got " + version;
            throw new IllegalArgumentException(message);
        }
        Proxy type = SOCKS_VERSION_5.equals(version) ? Proxy.SOCKS5 : Proxy.SOCKS4;
        int port = ProxyProvider.parsePort(properties.getProperty(SOCKS_PROXY_PORT, "1080"), SOCKS_PROXY_PORT);
        Builder proxy = ProxyProvider.builder().type(type).host(hostname).port(port);
        if (properties.containsKey(SOCKS_USERNAME)) {
            proxy = proxy.username(properties.getProperty(SOCKS_USERNAME));
        }
        if (properties.containsKey(SOCKS_PASSWORD)) {
            proxy = proxy.password(u -> properties.getProperty(SOCKS_PASSWORD));
        }
        return proxy.build();
    }

    static int parsePort(String port, String propertyName) {
        Objects.requireNonNull(port, "port");
        Objects.requireNonNull(propertyName, "propertyName");
        if (port.isEmpty()) {
            String message = "expected system property " + propertyName + " to be a number but got empty string";
            throw new IllegalArgumentException(message);
        }
        if (!port.chars().allMatch(Character::isDigit)) {
            String message = "expected system property " + propertyName + " to be a number but got " + port;
            throw new IllegalArgumentException(message);
        }
        return Integer.parseInt(port);
    }

    public static interface Builder {
        public Builder username(String var1);

        public Builder password(Function<? super String, ? extends String> var1);

        public Builder port(int var1);

        public Builder nonProxyHosts(String var1);

        public Builder nonProxyHostsPredicate(Predicate<SocketAddress> var1);

        public Builder httpHeaders(Consumer<HttpHeaders> var1);

        public Builder connectTimeoutMillis(long var1);

        public ProxyProvider build();
    }

    public static interface AddressSpec {
        public Builder host(String var1);

        public Builder address(InetSocketAddress var1);

        public Builder address(Supplier<? extends InetSocketAddress> var1);
    }

    public static interface TypeSpec {
        public AddressSpec type(Proxy var1);
    }

    @ChannelHandler.Sharable
    static final class UnvoidHandler
    extends ChannelOutboundHandlerAdapter {
        static final UnvoidHandler INSTANCE = new UnvoidHandler();

        UnvoidHandler() {
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            ctx.write(msg, promise.unvoid());
        }
    }

    static final class RegexShouldProxyPredicate
    implements Predicate<SocketAddress> {
        public static final RegexShouldProxyPredicate DEFAULT_NON_PROXY = RegexShouldProxyPredicate.fromWildcardedPattern("localhost|127.*|[::1]|0.0.0.0|[::0]");
        private final String regex;
        private final Pattern pattern;

        public static RegexShouldProxyPredicate fromWildcardedPattern(String pattern) {
            String transformed;
            if (StringUtil.isNullOrEmpty(pattern)) {
                transformed = "$^";
            } else {
                CharSequence[] parts = pattern.split("\\|");
                for (int i = 0; i < parts.length; ++i) {
                    parts[i] = RegexShouldProxyPredicate.transformWildcardComponent((String)parts[i]);
                }
                transformed = String.join((CharSequence)"|", parts);
            }
            return new RegexShouldProxyPredicate(transformed);
        }

        private static String transformWildcardComponent(String in) {
            CharSequence[] parts = new String[]{"", "", ""};
            if (in.startsWith("*")) {
                parts[0] = ".*";
                in = in.substring(1);
            }
            if (in.endsWith("*")) {
                parts[2] = ".*";
                in = in.substring(0, in.length() - 1);
            }
            parts[1] = Pattern.quote(in);
            return String.join((CharSequence)"", parts);
        }

        private RegexShouldProxyPredicate(String pattern) {
            this.regex = pattern;
            this.pattern = Pattern.compile(this.regex, 2);
        }

        @Override
        public boolean test(SocketAddress socketAddress) {
            if (!(socketAddress instanceof InetSocketAddress)) {
                return false;
            }
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            String hostString = isa.getHostString();
            return hostString != null && this.pattern.matcher(hostString).matches();
        }

        public String toString() {
            return this.regex;
        }
    }

    static final class Build
    implements TypeSpec,
    AddressSpec,
    Builder {
        static final Supplier<? extends HttpHeaders> NO_HTTP_HEADERS = () -> null;
        static final Predicate<SocketAddress> ALWAYS_PROXY = a -> false;
        String username;
        Function<? super String, ? extends String> password;
        String host;
        int port;
        Supplier<? extends InetSocketAddress> address;
        Predicate<SocketAddress> nonProxyHostPredicate = ALWAYS_PROXY;
        Supplier<? extends HttpHeaders> httpHeaders = NO_HTTP_HEADERS;
        Proxy type;
        long connectTimeoutMillis = 10000L;

        Build() {
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public final Builder password(Function<? super String, ? extends String> password) {
            this.password = password;
            return this;
        }

        @Override
        public final Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            return this;
        }

        @Override
        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public final Builder address(InetSocketAddress address) {
            Objects.requireNonNull(address, "address");
            this.address = () -> AddressUtils.replaceWithResolved(address);
            return this;
        }

        @Override
        public final Builder address(Supplier<? extends InetSocketAddress> addressSupplier) {
            this.address = Objects.requireNonNull(addressSupplier, "addressSupplier");
            return this;
        }

        @Override
        public final Builder nonProxyHosts(String nonProxyHostsPattern) {
            return StringUtil.isNullOrEmpty(nonProxyHostsPattern) ? this.nonProxyHostsPredicate(ALWAYS_PROXY) : this.nonProxyHostsPredicate(new RegexShouldProxyPredicate(nonProxyHostsPattern));
        }

        @Override
        public final Builder nonProxyHostsPredicate(Predicate<SocketAddress> nonProxyHostsPredicate) {
            this.nonProxyHostPredicate = Objects.requireNonNull(nonProxyHostsPredicate, "nonProxyHostsPredicate");
            return this;
        }

        @Override
        public Builder httpHeaders(final Consumer<HttpHeaders> headers) {
            if (headers != null) {
                this.httpHeaders = () -> new DefaultHttpHeaders(){
                    {
                        headers.accept(this);
                    }
                };
            }
            return this;
        }

        @Override
        public final AddressSpec type(Proxy type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @Override
        public Builder connectTimeoutMillis(long connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        @Override
        public ProxyProvider build() {
            return new ProxyProvider(this);
        }
    }

    public static enum Proxy {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

