/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.commons.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a3qAF\f\u0011\u0002G\u0005\u0002\u0005C\u0003(\u0001\u0019\u0005\u0001fB\u0003X/!\u0005\u0011GB\u0003\u0017/!\u0005a\u0006C\u00030\u0007\u0011\u0005\u0001G\u0002\u00034\u0007\t!\u0004\u0002\u0003\u001c\u0006\u0005\u0003\u0005\u000b\u0011B\u0015\t\u000b=*A\u0011A\u001c\t\u000fm*!\u0019!C\u0005y!1\u0001*\u0002Q\u0001\nuBq!S\u0003C\u0002\u0013%!\n\u0003\u0004L\u000b\u0001\u0006I!\u000b\u0005\u0006O\u0015!\t\u0001\u000b\u0004\u0005[\r\u0011A\n\u0003\u00057\u001b\t\u0005\t\u0015!\u0003*\u0011\u0015yS\u0002\"\u0001N\u0011\u001dYT\u00021A\u0005\n)Cq\u0001U\u0007A\u0002\u0013%\u0011\u000b\u0003\u0004I\u001b\u0001\u0006K!\u000b\u0005\b\u00136\u0011\r\u0011\"\u0003K\u0011\u0019YU\u0002)A\u0005S!)q%\u0004C\u0001Q\ti1)_2mS\u000e\u001cu.\u001e8uKJT!\u0001G\r\u0002\tU$\u0018\u000e\u001c\u0006\u00035m\tqaY8n[>t7O\u0003\u0002\u001d;\u00059q-\u0019;mS:<'\"\u0001\u0010\u0002\u0005%|7\u0001A\n\u0003\u0001\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0017a\u00028fqR4\u0016\r\u001c\u000b\u0002SA\u0011!EK\u0005\u0003W\r\u00121!\u00138uS\r\u0001Q\"\u0002\u0002\u000e\u001d>tG\u000b\u001b:fC\u0012\u001c\u0016MZ3\u0014\u0005\r\t\u0013A\u0002\u001fj]&$h\bF\u00012!\t\u00114!D\u0001\u0018\u0005)!\u0006N]3bIN\u000bg-Z\n\u0004\u000b\u0005*\u0004C\u0001\u001a\u0001\u0003\ri\u0017\r\u001f\u000b\u0003qi\u0002\"!O\u0003\u000e\u0003\rAQAN\u0004A\u0002%\nqaY8v]R,'/F\u0001>!\tqd)D\u0001@\u0015\t\u0001\u0015)\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u0005\u000e\u000b!bY8oGV\u0014(/\u001a8u\u0015\tABIC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d{$!D!u_6L7-\u00138uK\u001e,'/\u0001\u0005d_VtG/\u001a:!\u0003!i\u0017\r_%oI\u0016DX#A\u0015\u0002\u00135\f\u00070\u00138eKb\u00043cA\u0007\"kQ\u0011aj\u0014\t\u0003s5AQAN\bA\u0002%\n1bY8v]R,'o\u0018\u0013fcR\u0011!+\u0016\t\u0003EMK!\u0001V\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b-F\t\t\u00111\u0001*\u0003\rAH%M\u0001\u000e\u0007f\u001cG.[2D_VtG/\u001a:")
public interface CyclicCounter {
    public int nextVal();

    public static final class NonThreadSafe
    implements CyclicCounter {
        private int counter;
        private final int maxIndex;

        private int counter() {
            return this.counter;
        }

        private void counter_$eq(int x$1) {
            this.counter = x$1;
        }

        private int maxIndex() {
            return this.maxIndex;
        }

        @Override
        public int nextVal() {
            int current = this.counter();
            this.counter_$eq(this.counter() < this.maxIndex() ? this.counter() + 1 : 0);
            return current;
        }

        public NonThreadSafe(int max) {
            Predef$.MODULE$.require(max >= 2, (Function0 & Serializable)() -> "max must be >= 2");
            this.counter = 0;
            this.maxIndex = max - 1;
        }
    }

    public static final class ThreadSafe
    implements CyclicCounter {
        private final AtomicInteger counter;
        private final int maxIndex;

        private AtomicInteger counter() {
            return this.counter;
        }

        private int maxIndex() {
            return this.maxIndex;
        }

        @Override
        public int nextVal() {
            return this.counter().getAndUpdate(i -> {
                if (i < this.maxIndex()) {
                    return i + 1;
                }
                return 0;
            });
        }

        public ThreadSafe(int max) {
            Predef$.MODULE$.require(max >= 2, (Function0 & Serializable)() -> "max must be >= 2");
            this.counter = new AtomicInteger();
            this.maxIndex = max - 1;
        }
    }
}

