/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.stats;

import boopickle.Default$;
import boopickle.UnpickleState$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.charts.stats.LogFileParser;
import io.gatling.charts.stats.LogFileParser$;
import io.gatling.charts.stats.RunInfo;
import io.gatling.commons.stats.assertion.Assertion;
import io.gatling.commons.util.GatlingVersion$;
import io.gatling.core.stats.message.MessageEvent;
import io.gatling.core.stats.writer.RecordHeader;
import io.gatling.core.stats.writer.RunMessage;
import io.gatling.shared.model.assertion.AssertionPicklers$;
import java.io.EOFException;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001\u0002\n\u0014\rqA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tm\u0001\u0011\t\u0011)A\u0005o!)Q\b\u0001C\u0001}!9!\t\u0001a\u0001\n\u0013\u0019\u0005b\u0002&\u0001\u0001\u0004%Ia\u0013\u0005\u0007#\u0002\u0001\u000b\u0015\u0002#\t\u000fI\u0003\u0001\u0019!C\u0005\u0007\"91\u000b\u0001a\u0001\n\u0013!\u0006B\u0002,\u0001A\u0003&A\tC\u0003X\u0001\u0011%\u0001\fC\u0003\\\u0001\u0011%A\fC\u0003`\u0001\u0011%\u0001\rC\u0004\u0002\u001c\u0001!I!!\b\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&!9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0002bBA\u0018\u0001\u0011%\u0011\u0011\u0007\u0005\b\u0003g\u0001A\u0011IA\u001b\u0005=1\u0015N]:u!\u0006\u001c8\u000fU1sg\u0016\u0014(B\u0001\u000b\u0016\u0003\u0015\u0019H/\u0019;t\u0015\t1r#\u0001\u0004dQ\u0006\u0014Ho\u001d\u0006\u00031e\tqaZ1uY&twMC\u0001\u001b\u0003\tIwn\u0001\u0001\u0014\u0007\u0001iB\u0005E\u0002\u001f?\u0005j\u0011aE\u0005\u0003AM\u0011Q\u0002T8h\r&dW\rU1sg\u0016\u0014\bC\u0001\u0010#\u0013\t\u00193CA\u0004Sk:LeNZ8\u0011\u0005\u0015bS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0015+\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0016\u0002\u0007\r|W.\u0003\u0002.M\ti1\u000b\u001e:jGRdunZ4j]\u001e\fq\u0001\\8h\r&dW\r\u0005\u00021i5\t\u0011G\u0003\u0002\u001be)\t1'\u0001\u0003kCZ\f\u0017BA\u001b2\u0005\u00111\u0015\u000e\\3\u0002\ri|g.Z%e!\tA4(D\u0001:\u0015\tQ$'\u0001\u0003uS6,\u0017B\u0001\u001f:\u0005\u0019QvN\\3JI\u00061A(\u001b8jiz\"2a\u0010!B!\tq\u0002\u0001C\u0003/\u0007\u0001\u0007q\u0006C\u00037\u0007\u0001\u0007q'A\u0006j]*,7\r^*uCJ$X#\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\t1{gnZ\u0001\u0010S:TWm\u0019;Ti\u0006\u0014Ho\u0018\u0013fcR\u0011Aj\u0014\t\u0003\u000b6K!A\u0014$\u0003\tUs\u0017\u000e\u001e\u0005\b!\u0016\t\t\u00111\u0001E\u0003\rAH%M\u0001\rS:TWm\u0019;Ti\u0006\u0014H\u000fI\u0001\nS:TWm\u0019;F]\u0012\fQ\"\u001b8kK\u000e$XI\u001c3`I\u0015\fHC\u0001'V\u0011\u001d\u0001\u0006\"!AA\u0002\u0011\u000b!\"\u001b8kK\u000e$XI\u001c3!\u0003E)\b\u000fZ1uK&s'.Z2u'R\f'\u000f\u001e\u000b\u0003\u0019fCQA\u0017\u0006A\u0002\u0011\u000b!\"\u001a<f]R\u001cF/\u0019:u\u0003=)\b\u000fZ1uK&s'.Z2u\u000b:$GC\u0001'^\u0011\u0015q6\u00021\u0001E\u0003!)g/\u001a8u\u000b:$\u0017A\u00049beN,'+\u001e8SK\u000e|'\u000f\u001a\u000b\u0002CB)QI\u00193nw&\u00111M\u0012\u0002\u0007)V\u0004H.Z\u001a\u0011\u0005\u0015\\W\"\u00014\u000b\u0005\u001dD\u0017AB<sSR,'O\u0003\u0002\u0015S*\u0011!nF\u0001\u0005G>\u0014X-\u0003\u0002mM\nQ!+\u001e8NKN\u001c\u0018mZ3\u0011\u0007\u0015s\u0007/\u0003\u0002p\r\n)\u0011I\u001d:bsB\u0011\u0011\u000f\u001f\b\u0003eZ\u0004\"a\u001d$\u000e\u0003QT!!^\u000e\u0002\rq\u0012xn\u001c;?\u0013\t9h)\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u0014aa\u0015;sS:<'BA<G!\u0015a\u00181AA\u0005\u001d\tixP\u0004\u0002t}&\tq)C\u0002\u0002\u0002\u0019\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0006\u0005\u001d!\u0001\u0002'jgRT1!!\u0001G!\u0011\tY!a\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\t\u0011\"Y:tKJ$\u0018n\u001c8\u000b\u0007Q\t\u0019BC\u0002\u0002\u0016]\tqaY8n[>t7/\u0003\u0003\u0002\u001a\u00055!!C!tg\u0016\u0014H/[8o\u0003=\u0001\u0018M]:f+N,'OU3d_J$Gc\u0001'\u0002 !1\u0011\u0011E\u0007A\u0002\u0011\u000bab\u001d;beR$\u0016.\\3Ti\u0006l\u0007/\u0001\nqCJ\u001cXMU3rk\u0016\u001cHOU3d_J$Gc\u0001'\u0002(!1\u0011\u0011\u0005\bA\u0002\u0011\u000b\u0001\u0003]1sg\u0016<%o\\;q%\u0016\u001cwN\u001d3\u0015\u00071\u000bi\u0003\u0003\u0004\u0002\"=\u0001\r\u0001R\u0001\u0011a\u0006\u00148/Z#se>\u0014(+Z2pe\u0012$\u0012\u0001T\u0001\u0006a\u0006\u00148/\u001a\u000b\u0002C\u0001")
public final class FirstPassParser
extends LogFileParser<RunInfo>
implements StrictLogging {
    private final File logFile;
    private final ZoneId zoneId;
    private long injectStart;
    private long injectEnd;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private long injectStart() {
        return this.injectStart;
    }

    private void injectStart_$eq(long x$1) {
        this.injectStart = x$1;
    }

    private long injectEnd() {
        return this.injectEnd;
    }

    private void injectEnd_$eq(long x$1) {
        this.injectEnd = x$1;
    }

    private void updateInjectStart(long eventStart) {
        this.injectStart_$eq(package$.MODULE$.min(this.injectStart(), eventStart));
    }

    private void updateInjectEnd(long eventEnd) {
        this.injectEnd_$eq(package$.MODULE$.max(this.injectEnd(), eventEnd));
    }

    private Tuple3<RunMessage, String[], List<Assertion>> parseRunRecord() {
        String gatlingVersion;
        String string = gatlingVersion = this.readString();
        String string2 = GatlingVersion$.MODULE$.ThisVersion().fullVersion();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "The log file " + $this.logFile + " was generated with Gatling " + gatlingVersion + " and can't be parsed with Gatling " + GatlingVersion$.MODULE$.ThisVersion().fullVersion());
        String x$1 = gatlingVersion;
        String x$2 = this.readString();
        String x$3 = "";
        long x$4 = this.readLong();
        String x$5 = this.readString();
        ZoneId x$6 = this.zoneId;
        RunMessage localRunMessage = new RunMessage(x$2, "", x$4, x$5, x$1, x$6);
        String[] localScenarios = (String[])Array$.MODULE$.fill(this.readInt(), (Function0 & Serializable)() -> this.readSanitizedString(), ClassTag$.MODULE$.apply(String.class));
        List localAssertions = (List)scala.package$.MODULE$.List().fill(this.readInt(), (Function0 & Serializable)() -> {
            byte[] bytes = this.readByteArray();
            return (Assertion)Default$.MODULE$.Unpickle().apply(AssertionPicklers$.MODULE$.AssertionPickler()).fromBytes(ByteBuffer.wrap(bytes), UnpickleState$.MODULE$.unpickleStateSpeed());
        });
        return new Tuple3((Object)localRunMessage, (Object)localScenarios, (Object)localAssertions);
    }

    private void parseUserRecord(long startTimeStamp) {
        this.skipInt();
        MessageEvent.Start$ event = this.readBoolean() ? MessageEvent.Start$.MODULE$ : MessageEvent.End$.MODULE$;
        long timestamp = (long)this.readInt() + startTimeStamp;
        MessageEvent.Start$ start$ = event;
        MessageEvent.Start$ start$2 = MessageEvent.Start$.MODULE$;
        if (!(start$ != null ? !start$.equals(start$2) : start$2 != null)) {
            this.updateInjectStart(timestamp);
        }
        this.updateInjectEnd(timestamp);
    }

    private void parseRequestRecord(long startTimeStamp) {
        int groupsSize = this.readInt();
        int limit$macro$4 = groupsSize;
        for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
            this.skipCachedString();
        }
        this.skipCachedString();
        long startTimestamp = (long)this.readInt() + startTimeStamp;
        long endTimestamp = (long)this.readInt() + startTimeStamp;
        this.skipByte();
        this.skipCachedString();
        this.updateInjectStart(startTimestamp);
        this.updateInjectEnd(endTimestamp);
    }

    private void parseGroupRecord(long startTimeStamp) {
        int groupsSize = this.readInt();
        int limit$macro$4 = groupsSize;
        for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
            this.skipCachedString();
        }
        long startTimestamp = (long)this.readInt() + startTimeStamp;
        long endTimestamp = (long)this.readInt() + startTimeStamp;
        this.skipInt();
        this.skipByte();
        this.updateInjectStart(startTimestamp);
        this.updateInjectEnd(endTimestamp);
    }

    private void parseErrorRecord() {
        this.skipCachedString();
        this.skipInt();
    }

    @Override
    public RunInfo parse() {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("First pass");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        byte by = this.readByte();
        if (RecordHeader.Run$.MODULE$.value() != by) {
            throw new UnsupportedOperationException("The log file " + this.logFile + " is malformed and doesn't start with a proper record");
        }
        Tuple3<RunMessage, String[], List<Assertion>> tuple3 = this.parseRunRecord();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        RunMessage runMessage = (RunMessage)tuple3._1();
        String[] scenarios = (String[])tuple3._2();
        List assertions = (List)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)runMessage, (Object)scenarios, (Object)assertions);
        RunMessage runMessage2 = (RunMessage)tuple32._1();
        String[] scenarios2 = (String[])tuple32._2();
        List assertions2 = (List)tuple32._3();
        int count = 1;
        boolean bl = true;
        while (bl) {
            BoxedUnit boxedUnit3;
            if (++count % LogFileParser$.MODULE$.LogStep() == 0) {
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("First pass, read {} records", (Object)BoxesRunTime.boxToInteger((int)count));
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            byte headerValue = (byte)this.read();
            try {
                byte by2 = headerValue;
                if (RecordHeader.User$.MODULE$.value() == by2) {
                    this.parseUserRecord(runMessage2.start());
                    continue;
                }
                if (RecordHeader.Request$.MODULE$.value() == by2) {
                    this.parseRequestRecord(runMessage2.start());
                    continue;
                }
                if (RecordHeader.Group$.MODULE$.value() == by2) {
                    this.parseGroupRecord(runMessage2.start());
                    continue;
                }
                if (RecordHeader.Error$.MODULE$.value() == by2) {
                    this.parseErrorRecord();
                    continue;
                }
                if (-1 == by2) {
                    bl = false;
                    continue;
                }
                throw new UnsupportedOperationException("Unsupported header " + headerValue + " for record " + count);
            }
            catch (EOFException e) {
                BoxedUnit boxedUnit4;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Log file is truncated after record " + count + ", can only generate partial results.", (Throwable)e);
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                bl = false;
            }
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("First pass done: read {} records", (Object)BoxesRunTime.boxToInteger((int)count));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.assert(this.injectStart() != Long.MAX_VALUE, (Function0 & Serializable)() -> "Undefined run start");
        Predef$.MODULE$.assert(this.injectEnd() != Long.MIN_VALUE, (Function0 & Serializable)() -> "Undefined run end");
        Predef$.MODULE$.assert(this.injectEnd() > this.injectStart(), (Function0 & Serializable)() -> "Run didn't last");
        return new RunInfo(this.injectStart(), this.injectEnd(), runMessage2.simulationClassName(), runMessage2.runDescription(), runMessage2.start(), scenarios2, (List<Assertion>)assertions2);
    }

    public FirstPassParser(File logFile, ZoneId zoneId) {
        this.logFile = logFile;
        this.zoneId = zoneId;
        super(logFile);
        StrictLogging.$init$((StrictLogging)this);
        this.injectStart = Long.MAX_VALUE;
        this.injectEnd = Long.MIN_VALUE;
        Statics.releaseFence();
    }
}

