/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubeapitest;

import io.fabric8.kubeapitest.binary.OSInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.stream.Stream;
import org.slf4j.Logger;

public class Utils {
    public static final String WILDCARD_SUFFIX = ".*";
    private static final Random RANDOM = new Random();
    public static final SemverComparator SEMVER_COMPARATOR = new SemverComparator();

    private Utils() {
    }

    public static String getLatestVersion(List<String> versions) {
        versions.sort(SEMVER_COMPARATOR);
        return versions.get(versions.size() - 1);
    }

    public static void redirectProcessOutputToLogger(InputStream outputStream, Logger logger) {
        new Thread(() -> {
            Scanner sc = new Scanner(outputStream);
            while (sc.hasNextLine()) {
                logger.debug(sc.nextLine());
            }
        }).start();
    }

    public static String platformSuffix(OSInfo osInfo) {
        return "-" + osInfo.getOSName() + "-" + osInfo.getOSArch();
    }

    public static int findFreePort() {
        return Utils.findFreePort(49152, 65535, 100);
    }

    public static int findFreePort(int min, int max, int attempts) {
        int i = 0;
        while (i < attempts) {
            int n;
            int port = min + RANDOM.nextInt(max - min + 1);
            ServerSocket ignored = new ServerSocket(port);
            try {
                n = port;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
            ignored.close();
            return n;
        }
        throw new IllegalStateException("Cannot find a free random port in the range [" + min + ", " + max + "] after " + attempts + " attempts");
    }

    public static boolean isWildcardVersion(String version) {
        return version.endsWith(WILDCARD_SUFFIX);
    }

    public static String wildcardToPrefix(String wildcardVersion) {
        return wildcardVersion.substring(0, wildcardVersion.lastIndexOf("."));
    }

    public static void deleteDirectory(File file) throws IOException {
        try (Stream<Path> stream = Files.walk(file.toPath(), new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    private static class SemverComparator
    implements Comparator<String> {
        private SemverComparator() {
        }

        @Override
        public int compare(String v1, String v2) {
            String[] thisParts = v1.split("\\.");
            String[] thatParts = v2.split("\\.");
            int length = Math.max(thisParts.length, thatParts.length);
            for (int i = 0; i < length; ++i) {
                int thatPart;
                int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
                int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
                if (thisPart < thatPart) {
                    return -1;
                }
                if (thisPart <= thatPart) continue;
                return 1;
            }
            return 0;
        }
    }
}

