package fr.reseaumexico.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;

public abstract class Domain implements Serializable {

    private static final long serialVersionUID = 7220450224273187385L;

    public static final String PROPERTY_NAME = "name";

    public static final String PROPERTY_NOMINAL_VALUE = "nominalValue";

    public static final String PROPERTY_DISTRIBUTION_NAME = "distributionName";

    public static final String PROPERTY_VALUE_TYPE = "valueType";

    public static final String PROPERTY_LEVELS = "levels";

    public static final String PROPERTY_DISTRIBUTION_PARAMETER = "distributionParameter";

    protected String name;

    protected Object nominalValue;

    protected String distributionName;

    protected ValueType valueType;

    protected Collection<Level> levels;

    protected Collection<DistributionParameter> distributionParameter;

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        String oldValue = getName();
        this.name = name;
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public Object getNominalValue() {
        return nominalValue;
    }

    public void setNominalValue(Object nominalValue) {
        Object oldValue = getNominalValue();
        this.nominalValue = nominalValue;
        firePropertyChange(PROPERTY_NOMINAL_VALUE, oldValue, nominalValue);
    }

    public String getDistributionName() {
        return distributionName;
    }

    public void setDistributionName(String distributionName) {
        String oldValue = getDistributionName();
        this.distributionName = distributionName;
        firePropertyChange(PROPERTY_DISTRIBUTION_NAME, oldValue, distributionName);
    }

    public ValueType getValueType() {
        return valueType;
    }

    public void setValueType(ValueType valueType) {
        ValueType oldValue = getValueType();
        this.valueType = valueType;
        firePropertyChange(PROPERTY_VALUE_TYPE, oldValue, valueType);
    }

    public Level getLevels(int index) {
        Level o = getChild(levels, index);
        return o;
    }

    public void addLevels(Level levels) {
        getLevels().add(levels);
    
        firePropertyChange(PROPERTY_LEVELS, null, levels);
    }

    public void addAllLevels(Collection<Level> levels) {
        getLevels().addAll(levels);
    
        firePropertyChange(PROPERTY_LEVELS, null, levels);
    }

    public boolean removeLevels(Level levels) {
        boolean  removed = getLevels().remove(levels);
    
        if (removed) {
            firePropertyChange(PROPERTY_LEVELS, levels, null);
      }
    
        return removed;
    }

    public boolean removeAllLevels(Collection<Level> levels) {
        boolean  removed = getLevels().removeAll(levels);
    
        if (removed) {
            firePropertyChange(PROPERTY_LEVELS, levels, null);
      }
    
        return removed;
    }

    public boolean containsLevels(Level levels) {
        boolean contains = getLevels().contains(levels);
    
        return contains;
    }

    public boolean containsAllLevels(Collection<Level> levels) {
        boolean  contains = getLevels().containsAll(levels);
    
        return contains;
    }

    public Collection<Level> getLevels() {
        return levels;
    }

    public void setLevels(Collection<Level> levels) {
        Collection<Level> oldValue = getLevels();
        this.levels = levels;
        firePropertyChange(PROPERTY_LEVELS, oldValue, levels);
    }

    public DistributionParameter getDistributionParameter(int index) {
        DistributionParameter o = getChild(distributionParameter, index);
        return o;
    }

    public void addDistributionParameter(DistributionParameter distributionParameter) {
        getDistributionParameter().add(distributionParameter);
    
        firePropertyChange(PROPERTY_DISTRIBUTION_PARAMETER, null, distributionParameter);
    }

    public void addAllDistributionParameter(Collection<DistributionParameter> distributionParameter) {
        getDistributionParameter().addAll(distributionParameter);
    
        firePropertyChange(PROPERTY_DISTRIBUTION_PARAMETER, null, distributionParameter);
    }

    public boolean removeDistributionParameter(DistributionParameter distributionParameter) {
        boolean  removed = getDistributionParameter().remove(distributionParameter);
    
        if (removed) {
            firePropertyChange(PROPERTY_DISTRIBUTION_PARAMETER, distributionParameter, null);
      }
    
        return removed;
    }

    public boolean removeAllDistributionParameter(Collection<DistributionParameter> distributionParameter) {
        boolean  removed = getDistributionParameter().removeAll(distributionParameter);
    
        if (removed) {
            firePropertyChange(PROPERTY_DISTRIBUTION_PARAMETER, distributionParameter, null);
      }
    
        return removed;
    }

    public boolean containsDistributionParameter(DistributionParameter distributionParameter) {
        boolean contains = getDistributionParameter().contains(distributionParameter);
    
        return contains;
    }

    public boolean containsAllDistributionParameter(Collection<DistributionParameter> distributionParameter) {
        boolean  contains = getDistributionParameter().containsAll(distributionParameter);
    
        return contains;
    }

    public Collection<DistributionParameter> getDistributionParameter() {
        return distributionParameter;
    }

    public void setDistributionParameter(Collection<DistributionParameter> distributionParameter) {
        Collection<DistributionParameter> oldValue = getDistributionParameter();
        this.distributionParameter = distributionParameter;
        firePropertyChange(PROPERTY_DISTRIBUTION_PARAMETER, oldValue, distributionParameter);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }

    protected <T> T getChild(Collection<T> childs, int index) {
        if (childs != null) {
            int i = 0;
            for (T o : childs) {
                if (index == i) {
                    return o;
                }
                i++;
            }
        }
        return null;
    }

} //Domain
