/*
 * #%L
 * JMexico :: Model
 * 
 * $Id: XmlWriter.java 32 2012-01-18 16:58:27Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/jmexico/tags/jmexico-0.4/jmexico-model/src/main/java/fr/reseaumexico/model/writer/XmlWriter.java $
 * %%
 * Copyright (C) 2011 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.reseaumexico.model.writer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

/**
 * Abstract writer to create xml files using {@link XmlNode}
 *
 * @author sletellier <letellier@codelutin.com>
 * @since 0.1
 */
public abstract class XmlWriter<M> extends FileWriter {

    public static final int INDENT = 2;

    protected M model;

    public XmlWriter(File file, M model) throws IOException {
        super(file);
        this.model = model;
    }

    public void write() throws IOException {

        String toWrite = getRootElement().toXml(INDENT);
        write(toWrite);
    }

    public abstract XmlNode getRootElement();

}
