/*
 * #%L
 * JMexico :: Swing Editor
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2011 - 2012 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.reseaumexico.editor;

import fr.reseaumexico.editor.factorValue.FactorValueCellEditor;
import fr.reseaumexico.editor.factorValue.FactorValueCellRenderer;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.InputDesign;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.renderer.DecoratorProviderTableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class InputDesignEditor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_MODEL = "model";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_INPUT_DESIGN_TABLE_MODEL = "inputDesignTable.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVUz08TQRR+rbTYAkpBESMaBE1MNFujMTFC+GGVAClqqDHEXpzuDHTIdGacnYXlYvwT/BP07sXEmyfjwbMHL8Z/wRgPXo0zu+0urUvAPcxs3nvfN997M++9/QE5T8HFbRQEjvK5pi3irC5ubDxsbBNX3yOeq6jUQkH0ZbKQrcMAju2ehul61cLLbXi5IlpScML3oWeqUPT0HiNekxCt4Xw3wvW8ci12zwTSVx3WWFQa6+tfP7Ov8Ms3WYBAGnVFk8rkYagkk74qZCnWMGJO2kFlhviWkaEo3zJ6h6ytwpDnPUAt8hxeQH8V8hIpQ6Zh6ugphxwhPpAaSpRL34bRLX4fUxOo4cqmchTxCPJbJKCucEjocFZ6Q6UMifIa+puIY0YMuHxU8HKESDhyLYEJ03DtcIbHqMHImg1P4EWXMNZJ4fYBHJvINdsTxHziLCX/lRia8A1avnXCMVE2rzv/z9gBJ5xDl1ZrrhKMPUKcXNdwxl5q4Hi75o6dfS4bXohRw7Qnc/NEuoCh0QaPx5hSpGvR1VRwS8l6QaGx+6ASwrjmEo4UFXd9rQXXMNoFiqw2/EKMOqVIS+yQbqD1TbfjFJzragLTXk7SXsn7z9Qhp3xj1jBe/7cj140r6sXxnl60hKH3z9jo1w/f3y91GrDPnH06NXTf/DCNIZWQ5pKpPfpk1H2+pqy8huRMHQoeYcSNhstEirBa223EmfNKFu5YuLOMvKahyPV/+/hp7NmXY5BdgiITCEcPZQUKumneVFMwHMj5hVDR4O5xsw5bbRryDO0JU084MYuRRpMNyrG5h7nAFGEipQixkkbh8+/R2ruFTiEyRtjZA8OTYuSeQp5yRjkJZ1F7zKTOngHpER+LZJykDZiM3Yuy3QFXw7WclmnU/NZ9I/DtdjNUbf9uhSQTRyDp0yQwxRqZjVKYRNpMz4avyVw659ShnNY8Z5f5dIbLhuEvukpYlrQGAAA=";
    private static final Log log = LogFactory.getLog(InputDesignEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addScenarioButton;
    protected FactorValueCellEditor cellEditor;
    protected FactorValueCellRenderer cellRenderer;
    protected JPanel factorActionPanel;
    protected InputDesignEditorHandler handler;
    protected InputDesignEditor inputDesignEditor = this;
    protected JTable inputDesignTable;
    protected InputDesignTableModel model;
    protected JButton removeScenarioButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private void $afterCompleteSetup() {
    
        // table renderer
        // TODO sletellier 20111221 : do on time for all, put in context ?
        MexicoDecoratorProvider mexicoDecoratorProvider = new MexicoDecoratorProvider();
        inputDesignTable.setDefaultRenderer(Factor.class, new DecoratorProviderTableCellRenderer(mexicoDecoratorProvider));
        inputDesignTable.setDefaultRenderer(Object.class, getCellRenderer());
    
        // cell editor
        inputDesignTable.setDefaultEditor(Object.class, getCellEditor());
    }
    
    public void setInputDesign(InputDesign inputDesign) {
        getModel().setInputDesign(inputDesign);
    }
    
    public InputDesign getInputDesign() {
        return getModel().getInputDesign();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public InputDesignEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public InputDesignEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public InputDesignEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public InputDesignEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public InputDesignEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public InputDesignEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public InputDesignEditor() {
        $initialize();
    }

    public InputDesignEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addScenarioButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().addScenario(this);
    }

    public void doActionPerformed__on__removeScenarioButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().removeScenario(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddScenarioButton() {
        return addScenarioButton;
    }

    public FactorValueCellEditor getCellEditor() {
        return cellEditor;
    }

    public FactorValueCellRenderer getCellRenderer() {
        return cellRenderer;
    }

    public JPanel getFactorActionPanel() {
        return factorActionPanel;
    }

    public InputDesignEditorHandler getHandler() {
        return handler;
    }

    public JTable getInputDesignTable() {
        return inputDesignTable;
    }

    public InputDesignTableModel getModel() {
        return model;
    }

    public JButton getRemoveScenarioButton() {
        return removeScenarioButton;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setModel(InputDesignTableModel model) {
        InputDesignTableModel oldValue = this.model;
        this.model = model;
        firePropertyChange(PROPERTY_MODEL, oldValue, model);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFactorActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        factorActionPanel.add(addScenarioButton, BorderLayout.WEST);
        factorActionPanel.add(removeScenarioButton, BorderLayout.EAST);
    }

    protected void addChildrenToInputDesignEditor() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0, BorderLayout.CENTER);
        add(factorActionPanel, BorderLayout.SOUTH);
    }

    protected void createAddScenarioButton() {
        $objectMap.put("addScenarioButton", addScenarioButton = new JButton());
        
        addScenarioButton.setName("addScenarioButton");
        addScenarioButton.setText(_("jmexico.add.scenario"));
        addScenarioButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addScenarioButton"));
    }

    protected void createCellEditor() {
        $objectMap.put("cellEditor", cellEditor = new FactorValueCellEditor(this));
    }

    protected void createCellRenderer() {
        $objectMap.put("cellRenderer", cellRenderer = new FactorValueCellRenderer(this));
    }

    protected void createFactorActionPanel() {
        $objectMap.put("factorActionPanel", factorActionPanel = new JPanel());
        
        factorActionPanel.setName("factorActionPanel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new InputDesignEditorHandler());
    }

    protected void createInputDesignTable() {
        $objectMap.put("inputDesignTable", inputDesignTable = new JTable());
        
        inputDesignTable.setName("inputDesignTable");
    }

    protected void createModel() {
        $objectMap.put("model", model = new InputDesignTableModel());
    }

    protected void createRemoveScenarioButton() {
        $objectMap.put("removeScenarioButton", removeScenarioButton = new JButton());
        
        removeScenarioButton.setName("removeScenarioButton");
        removeScenarioButton.setText(_("jmexico.remove.scenario"));
        removeScenarioButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeScenarioButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToInputDesignEditor();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(inputDesignTable);
        addChildrenToFactorActionPanel();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("inputDesignEditor", inputDesignEditor);
        createHandler();
        createModel();
        createCellEditor();
        createCellRenderer();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createInputDesignTable();
        createFactorActionPanel();
        createAddScenarioButton();
        createRemoveScenarioButton();
        // inline creation of inputDesignEditor
        setName("inputDesignEditor");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_INPUT_DESIGN_TABLE_MODEL, true ,"model") {
        
            @Override
            public void processDataBinding() {
                inputDesignTable.setModel(getModel());
            }
        });
    }

}