package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.user.bean.UserFormBean;
import org.apache.log4j.Logger;

/**
 * This action handles the user territory edition.
 * It allows the end user to edit its territory.
 *
 * @author CS
 */
public class UpdateUserTerritoryAction extends AbstractUserAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AbstractUserAction.class);

    /**
     * territory id
     */
    protected String territoryId;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug(getText("fr.onema.sispea.struts.user.action.UpdateUserTerritoryAction.debug.doExecute"));
        }

        // init
        String lRes = Action.SUCCESS;

        // menu
        openMenu(MenuConstants.MENU_KEY_SEE_USER);

        // check rights
        // territory can't be changed on its own profile -> edit user right required
        if (!checkUserRight(Right.EditUser)) {
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // get current user's territory
        TerritoryDto lCurrentTerritory = getCurrentUserTerritory();
        if (lCurrentTerritory == null) {
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // convert territory id
        Integer lTerritoryIdInt = Integer.valueOf(territoryId);

        try {

            // add territory to user
            userService.updateUserTerritory(user.getLogin(), lTerritoryIdInt, lCurrentTerritory, true, exerciseService.getCurrentExerciseId());

        } catch (SispeaException e) {
            // input error
            lRes = Action.INPUT;

            // error message
            addActionError(getText(e.getMessage()));
        }

        // reload user
        user = new UserFormBean(userService.readUser(user.getLogin()));

        if (lRes.equals(Action.SUCCESS)) {
            // success message
            addActionMessage(getText("fr.onema.sispea.struts.user.action.UpdateUserTerritoryAction.message.update"));
        }

        // test if user if corrupted
        checkUserCorruption();

        // result
        return lRes;

    }

    public String getTerritoryId() {
        return territoryId;
    }

    public void setTerritoryId(String pTerritoryId) {
        territoryId = pTerritoryId;
    }

}
