package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/**
 * This action handles the user selections visualization.
 * It allows the end user to save its selections.
 *
 * @author CS
 */
public class UpdateUserSelectionMultipleAction extends AbstractUserSelectionMultipleAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateUserSelectionMultipleAction.class);

    /**
     * The submit button activated.
     */
    protected String selectionName;

    /**
     * IDs of the chosen territories to add to the mixed territory.
     */
    protected List<String> territoryIdsSave;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("show user's selection multiple");
        }

        // init result
        String lResult = Action.SUCCESS;

        // open menu
        openMenu(MenuConstants.MENU_KEY_MYSELECTION);

        try {
            // check submit value
            if (submitValue == null) {
                throw new SispeaException("fr.onema.sispea.jsp.user.updateUserSelections.unknownAction");
            }

            // get the current user
            UserDto lUser = getCurrentUser();

            if (territoryId != null) {
                // the user is authenticated

                // convert territory id
                Integer lTerritoryIdInt;
                try {
                    lTerritoryIdInt = Integer.valueOf(territoryId);
                } catch (NumberFormatException lEx) {
                    throw new SispeaException("fr.onema.sispea.jsp.user.updateUserSelectionMultiple.wrongFormatId");
                }

                // read territories
                selection = territoryService.readTerritory(lTerritoryIdInt);
            }


            if (getText("fr.onema.sispea.jsp.user.showUserSelectionMultiple.deleteOrganism").equals(submitValue) && selection != null) {
                // Delete organism
                String lOrganismName = null;

                // transform organism id to integer
                Integer lOrganismId;
                try {
                    lOrganismId = Integer.valueOf(organismIdDelete);
                } catch (NumberFormatException lEx) {
                    throw new SispeaException("fr.onema.sispea.jsp.user.updateUserSelectionMultiple.wrongFormatId");
                }

                // Get list of all organisms ID to remove and update the organisms list.
                Collection<OrganismDto> lOrganisms = selection.getOrganisms();

                // For each organism associated to this territory...
                for (Iterator<OrganismDto> iterator = lOrganisms.iterator(); iterator.hasNext(); ) {
                    OrganismDto lOrg = iterator.next();
                    if (lOrg.getId().equals(lOrganismId)) {
                        iterator.remove();
                        lOrganismName = lOrg.getName();
                    }
                }

                selection.setOrganisms(lOrganisms);

                // Save territory into the database.
                referentialService.updateTerritory(selection);

                addActionMessage(getText("fr.onema.sispea.jsp.user.updateUserSelectionMultiple.organismRemoved", "", lOrganismName));

            } else if (getText("fr.onema.sispea.jsp.user.showUserSelectionMultiple.editName").equals(submitValue) && selection != null) {

                if (selectionName != null && selectionName.length() == 0) {
                    addActionError(getText("fr.onema.sispea.jsp.user.updateUserSelectionMultiple.nameInvalid"));
                } else {
                    // change name
                    selection.setName(selectionName);

                    // Save territory into the database.
                    referentialService.updateTerritory(selection);

                    addActionMessage(getText("fr.onema.sispea.jsp.user.updateUserSelectionMultiple.nameChanged"));
                }

            } else if (territoryIdsSave != null && territoryIdsSave.size() > 0) {

                if (selection == null) {
                    // Add a new empty territory.
                    Integer lCreatedID = territoryService.createTerritory(getText("fr.onema.sispea.jsp.user.showUserSelectionMultiple.defaultName"), lUser);

                    // Get created territory
                    selection = territoryService.readTerritory(lCreatedID);

                    territoryId = lCreatedID.toString();
                }

                // add organisms to an existing selection
                for (String lStrTerritoryId : territoryIdsSave) {
                    // transform to integer
                    Integer lTerritoryId;
                    try {
                        lTerritoryId = Integer.valueOf(lStrTerritoryId);
                    } catch (NumberFormatException lEx) {
                        throw new SispeaException("fr.onema.sispea.jsp.user.updateUserSelectionMultiple.wrongFormatId");
                    }

                    // Load the organism from the DB.
                    TerritoryDto lTerritory = territoryService.readTerritory(lTerritoryId);

                    // Add all organisms from the chosen territory, but avoid doubles.
                    for (OrganismDto lOrg : lTerritory.getOrganisms()) {
                        // If organism doesn't already exists into the territory...
                        if (!selection.getOrganisms().contains(lOrg)) {
                            // Add it to the territory.
                            selection.addOrganism(lOrg);
                        }
                    }
                }
                // Save territory into the database.
                referentialService.updateTerritory(selection);

                addActionMessage(getText("fr.onema.sispea.jsp.user.updateUserSelectionMultiple.organismAdded", "", Integer.toString(territoryIdsSave.size())));
            }

            // Display updated multiple selection
            manageShowUserSelectionMultiple();

        } catch (SispeaException lEx) {
            String lMessage = getText(lEx.getMessage());
            logger.error(lMessage);
            addActionError(lMessage);
            lResult = Action.INPUT;
        }

        return lResult;
    }

    public String getSelectionName() {
        return selectionName;
    }

    public void setSelectionName(String pSelectionName) {
        selectionName = pSelectionName;
    }

    public List<String> getTerritoryIdsSave() {
        return territoryIdsSave;
    }

    public void setTerritoryIdsSave(List<String> pTerritoryIdsSave) {
        territoryIdsSave = pTerritoryIdsSave;
    }

}
