package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.search.SearchTerritoryDto;
import fr.onema.sispea.service.search.UsersFilterDto;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.SispeaSession;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * This action handles the user visualization.
 * It allows the end user to view user props.
 *
 * @author CS
 */

public class UpdateMyRequestsAction extends AbstractMyRequestsAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateMyRequestsAction.class);

    /**
     * the user update mode
     */
    private static final int UPDATE_USERS_MODE = 1;

    /**
     * the territories update mode
     */
    private static final int UPDATE_TERRITORIES_MODE = 2;

    /**
     * the update mode : users or territories
     */
    protected int updateMode;

    /**
     * the edited name
     */
    protected String editedName;

    @Override
    protected String doExecute() throws Exception {


        if (logger.isDebugEnabled()) {
            logger.debug("show user's selections");
        }

        // init result
        String lResult = Action.SUCCESS;
        // menu
        openMenu(MenuConstants.MENU_KEY_MYREQUESTS);
        // get the current user
        UserDto lUser = getCurrentUser();


        try {

            if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.jsp.user.myRequest.user.cancel"))) {
                numEdit = 0;
                editing = false;
            } else if (submitValue != null) {

                if (lUser == null) {
                    // session
                    SispeaSession lSession = getSispeaSession();
                    if (lSession == null) {
                        throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
                    }
                    // get requests in session :
                    List<SearchTerritoryDto> mySearchsTerritorys = lSession.getMySearchsTerritorys();
                    List<UsersFilterDto> mySearchsUsers = lSession.getMySearchsUsers();

                    //edit limits mode :
                    if (submitValue.equals(getText("fr.onema.sispea.jsp.user.myRequest.user.delete")) && (updateMode == UPDATE_USERS_MODE)) {
                        mySearchsUsers.remove(numAction);
                        lSession.setMySearchsUsers(mySearchsUsers);
                        addActionMessage(getText("fr.onema.sispea.jsp.user.myRequest.messages.deleteUserSearch"));
                    }

                    //add request in session :
                    if (submitValue.equals("saveUsersCriterion") && (updateMode == UPDATE_USERS_MODE)) {
                        // get requests in session :
                        mySearchsUsers.add(searchUsersInfo.getFilter());
                        getSispeaSession().setMySearchsUsers(mySearchsUsers);
                        addActionMessage(getText("fr.onema.sispea.jsp.user.myRequest.messages.newUserSearch"));
                    }

                    // name saving
                    if (submitValue.equals(getText("fr.onema.sispea.jsp.user.myRequest.territory.save"))) {
                        // mode ?
                        if (updateMode == UPDATE_TERRITORIES_MODE) {
                            SearchTerritoryDto lFoundInSession = null;
                            for (SearchTerritoryDto sessionSearchTerritoryBean : mySearchsTerritorys) {
                                // check if session search territory equals current search territory (searchTerritoryBean)
                                if (compareTerritorySearch(sessionSearchTerritoryBean, searchTerritoryBean)) {
                                    lFoundInSession = sessionSearchTerritoryBean;
                                }
                            }
                            lFoundInSession.setName(editedName);
                            addActionMessage(getText("fr.onema.sispea.jsp.user.myRequest.messages.nameChanged"));
                        }
                    }

                    //edit limits mode :
                    if (submitValue.equals(getText("fr.onema.sispea.jsp.user.myRequest.territory.delete")) && (updateMode == UPDATE_TERRITORIES_MODE)) {
                        SearchTerritoryDto lFoundInSession = null;
                        for (SearchTerritoryDto sessionSearchTerritoryBean : mySearchsTerritorys) {
                            // check if session search territory equals current search territory (searchTerritoryBean)
                            if (compareTerritorySearch(sessionSearchTerritoryBean, searchTerritoryBean)) {
                                lFoundInSession = sessionSearchTerritoryBean;
                            }
                        }
                        if (lFoundInSession != null) {
                            mySearchsTerritorys.remove(lFoundInSession);
                            lSession.setMySearchsTerritorys(mySearchsTerritorys);
                            addActionMessage(getText("fr.onema.sispea.jsp.user.myRequest.messages.deleteUserSearch"));
                        }
                    }

                    //add request in session :
                    if (submitValue.equals("saveCriterion") && (updateMode == UPDATE_TERRITORIES_MODE)) {
                        // get requests in session :
                        SearchTerritoryDto lFoundInSession = null;
                        Integer lNextId = 0;
                        for (SearchTerritoryDto sessionSearchTerritoryBean : mySearchsTerritorys) {
                            // increment id
                            lNextId = sessionSearchTerritoryBean.getId();

                            // check if session search territory equals current search territory (searchTerritoryBean)
                            if (compareTerritorySearch(sessionSearchTerritoryBean, searchTerritoryBean)) {
                                lFoundInSession = sessionSearchTerritoryBean;
                            }
                        }

                        // found search request ion session ?
                        if (lFoundInSession == null) {
                            // set id
                            searchTerritoryBean.setId(lNextId + 1);
                            // add search request into session
                            mySearchsTerritorys.add(searchTerritoryBean);
                            getSispeaSession().setMySearchsTerritorys(mySearchsTerritorys);
                        } else {
                            // get id
                            searchTerritoryBean.setId(lFoundInSession.getId());
                        }
                        addActionMessage(getText("fr.onema.sispea.jsp.user.myRequest.messages.newTerritorySearch"));
                    }
                } else {

                    if (submitValue.equals("saveUsersCriterion") && (updateMode == UPDATE_USERS_MODE)) {
                        // save user criterion
                        referentialService.addToUserSearchUser(lUser, searchUsersInfo.getFilter());
                        addActionMessage(getText("fr.onema.sispea.jsp.user.myRequest.messages.newUserSearch"));
                    }

                    // name saving
                    if (submitValue.equals(getText("fr.onema.sispea.jsp.user.myRequest.territory.save"))) {

                        // mode ?
                        if (updateMode == UPDATE_TERRITORIES_MODE) {

                            // read DB user search
                            SearchTerritoryDto lDbTerritorySearch = referentialService.readMySearchTerritoryById(lUser, numEdit);

                            //update
                            lDbTerritorySearch.setName(editedName);

                            // save
                            referentialService.addToUserSearchTerritory(lUser, lDbTerritorySearch);
                            addActionMessage(getText("fr.onema.sispea.jsp.user.myRequest.messages.nameChanged"));

                        } else {
                            // read DB user search
                            UsersFilterDto lDbUserSearch = referentialService.readMySearchUsersById(lUser, numEdit);

                            //update
                            lDbUserSearch.setName(editedName);

                            // save
                            referentialService.addToUserSearchUser(lUser, lDbUserSearch);
                            addActionMessage(getText("fr.onema.sispea.jsp.user.myRequest.messages.nameChanged"));

                        }
                    }

                    if (submitValue.equals(getText("fr.onema.sispea.jsp.user.myRequest.user.delete")) && (updateMode == UPDATE_USERS_MODE)) {
                        // save user criterion
                        referentialService.removeToUserSearchUser(lUser, numEdit);
                        addActionMessage(getText("fr.onema.sispea.jsp.user.myRequest.messages.deleteUserSearch"));
                    }

                    // the user is authenticated
                    if (submitValue.equals(getText("fr.onema.sispea.jsp.user.myRequest.territory.delete")) && (updateMode == UPDATE_TERRITORIES_MODE)) {
                        referentialService.removeToUserSearchTerritory(lUser, numEdit);
                        addActionMessage(getText("fr.onema.sispea.jsp.user.myRequest.messages.deleteTerritorySearch"));
                    }

                    //add request in session :
                    if (submitValue.equals("saveCriterion") && (updateMode == UPDATE_TERRITORIES_MODE)) {
                        // add territory to user selection
                        referentialService.addToUserSearchTerritory(lUser, searchTerritoryBean);
                    }
                }

                // end of edition
                editing = false;
                numEdit = 0;
            }

            // Load requests
            manageShowMyRequests();

        } catch (SispeaException lEx) {
            String lMessage = getText("fr.onema.sispea.jsp.user.myRequest.messages.errorUpdate");
            logger.error(lMessage);
            addActionError(lMessage);
            lResult = Action.INPUT;
        }

        // result
        return lResult;

    }

    public int getUpdateMode() {
        return updateMode;
    }

    public void setUpdateMode(int pUpdateMode) {
        updateMode = pUpdateMode;
    }

    public String getEditedName() {
        return editedName;
    }

    public void setEditedName(String pEditedName) {
        editedName = pEditedName;
    }

}
