package fr.onema.sispea.struts.synthesis.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.synthesis.ChartValueDto;
import fr.onema.sispea.util.constants.NumberUtils;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * This class is modeling a scatter chart value to be rendered by the JWebChart servlet.
 *
 * @author CS
 */
public class ScatterValueBean extends ChartValueDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The x value the scatter chart value.
     */
    protected String xValue = null;

    /**
     * The y value the scatter chart value.
     */
    protected String yValue = null;

    public ScatterValueBean() {

    }

    public ScatterValueBean(String pName, int pXValue, int pYValue) {
        super(pName);
        xValue = String.valueOf(pXValue);
        yValue = String.valueOf(pYValue);
    }

    public ScatterValueBean(String pName, Double pXValue, Double pYValue) {
        super(pName);
        if (pXValue == null || pXValue.floatValue() == NumberUtils.DEFAULT_EMPTY_FLOAT_VALUE) {
            xValue = null;
        } else {
            xValue = String.valueOf(pXValue);
        }

        if (pYValue == null || pYValue.floatValue() == NumberUtils.DEFAULT_EMPTY_FLOAT_VALUE) {
            yValue = null;
        } else {
            yValue = String.valueOf(pYValue);
        }
    }

    @Override
    public String getEncodedValue() throws UnsupportedEncodingException {
        return URLEncoder.encode(xValue, ENCODING) + SEPARATOR + URLEncoder.encode(yValue, ENCODING);
    }

    public String getXValue() {
        return xValue;
    }

    public String getYValue() {
        return yValue;
    }
}
