package fr.onema.sispea.struts.synthesis.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.synthesis.ChartValueDto;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

/**
 * This class is modeling a BoxAndWhisker chart value to be rendered by the JWebChart servlet.
 *
 * @author CS
 */
public class BoxAndWhiskerValueBean extends ChartValueDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The label of the category chart value.
     */
    protected String label = null;

    /**
     * The values of the chart value.
     */
    protected List<Double> values = null;

    public BoxAndWhiskerValueBean() {
        super();
    }

    public BoxAndWhiskerValueBean(String pName, String pLabel, List<Double> pValues) {
        super(pName);
        label = pLabel;
        values = pValues;
    }

    /**
     * @return The value to be used in the url for this value.
     */
    @Override
    public String getEncodedValue() throws UnsupportedEncodingException {
        return URLEncoder.encode(label, ENCODING) + SEPARATOR + URLEncoder.encode(values.toString(), ENCODING);
    }

    public String getLabel() {
        return label;
    }

    public List<Double> getValues() {
        return values;
    }
}
