package fr.onema.sispea.struts.referential.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.SispeaInputException;
import fr.onema.sispea.service.data.DataDto;
import fr.onema.sispea.service.data.SPEALotDto;
import fr.onema.sispea.struts.referential.action.AbstractSpeaIndicatorsAction;
import fr.onema.sispea.struts.referential.xml.XmlGroupType;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


/**
 * This class is a support class to read xml group from a xml file
 *
 * @author CS
 */
public class XmlGroupTab extends XmlGroup {

    private static final long serialVersionUID = 1L;

    /**
     * xml sub group list
     */
    protected List<XmlGroupTable> groupTables = new ArrayList<>();

    /**
     * Default constructor.
     */
    public XmlGroupTab() {
        super();
    }

    /**
     * copy constructor.
     */
    public XmlGroupTab(XmlGroupTab pXmlGroup) {
        super(pXmlGroup);
    }

    /**
     * updates the tab group and returns it updated
     *
     * @return
     * @throws SispeaException
     */
    public static XmlGroupTab updateXmlGroupTab(SPEALotDto pLot, SPEALotDto pOldLot, int pCompetenceId, Boolean pHasViewRight,
                                                XmlGroupTab pXmlGroupTab, AbstractSpeaIndicatorsAction pAction) throws SispeaException {

        // init
        XmlGroupTab lXmlGroupTab = pXmlGroupTab;

        if (lXmlGroupTab != null) {

            // result list
            List<XmlGroupTable> lTables = new ArrayList<>();

            // update tables
            for (XmlGroupTable lXmlGroupTable : lXmlGroupTab.getGroupTables()) {
                // update
                lXmlGroupTable = XmlGroupTable.updateXmlGroupTable(pLot, pOldLot, pCompetenceId, pHasViewRight, lXmlGroupTable, pAction);
                if (lXmlGroupTable != null && !lXmlGroupTable.isEmpty()) {
                    lTables.add(lXmlGroupTable);
                }
            }

            // check if tables contains at least one IP
            boolean lDataFound = false;
            for (Iterator<XmlGroupTable> iterator = lTables.iterator(); iterator.hasNext() && !lDataFound; ) {
                XmlGroupTable xmlGroupTable = iterator.next();

                if (xmlGroupTable.getDisplayAsDC() != null && xmlGroupTable.getDisplayAsDC()) {
                    lDataFound = true;
                }

                for (Iterator<XmlGroupTableValue> iterator2 = xmlGroupTable.getGroupTableValues().iterator(); iterator2.hasNext() && !lDataFound; ) {
                    XmlGroupTableValue xmlGroupTableValue = iterator2.next();

                    if (xmlGroupTableValue.isIndicatorValue()) {
                        lDataFound = true;
                    }
                }
            }

            // set list ?
            if (lDataFound) {
                lXmlGroupTab.groupTables = lTables;
            } else {
                lXmlGroupTab.groupTables = new ArrayList<>();
            }

        }

        // result
        return lXmlGroupTab;
    }

    /**
     * updates lot with group data
     *
     * @param pXmlGroupTab
     * @param pLot
     * @return
     * @throws SispeaException
     */
    public static SPEALotDto updateLotWithGroupData(XmlGroupTab pXmlGroupTab, SPEALotDto pLot) throws SispeaException, SispeaInputException {

        // init
        SPEALotDto lRes = pLot;

        for (XmlGroupTable lXmlGroupTable : pXmlGroupTab.getGroupTables()) {
            // update lot
            lRes = XmlGroupTable.updateLotWithGroupData(lXmlGroupTable, lRes);
        }

        // result
        return lRes;
    }

    /**
     * return a table detail (or its clone if indicated) corresponding to id passed. Null if not found
     *
     * @param pXmlGroupTableDetailId
     * @param pXmlGroupTabs
     * @param pCloneResult           if true result is the clone, else it's the result its self
     * @return
     */
    public static XmlGroupTableDetail findTableDetail(String pXmlGroupTableDetailId, List<XmlGroupTab> pXmlGroupTabs, boolean pCloneResult) {

        // init
        XmlGroupTableDetail lRes = null;

        // search in tabs
        for (Iterator<XmlGroupTab> iterator = pXmlGroupTabs.iterator(); iterator.hasNext() && lRes == null; ) {
            XmlGroupTab lXmlGroupTab = iterator.next();

            // search in tables
            for (Iterator<XmlGroupTable> iterator2 = lXmlGroupTab.getGroupTables().iterator(); iterator2.hasNext() && lRes == null; ) {
                XmlGroupTable lXmlGroupTable = iterator2.next();
                lRes = XmlGroupTable.findTableDetail(pXmlGroupTableDetailId, lXmlGroupTable, pCloneResult);
            }
        }


        // result
        return lRes;
    }

    public static XmlGroupTableValue findTableValueContainingDetail(Integer pDetailTypeId, XmlGroupTab pXmlGroupTab) {

        // init
        XmlGroupTableValue lRes = null;

        // search in tables
        for (Iterator<XmlGroupTable> iterator2 = pXmlGroupTab.getGroupTables().iterator(); iterator2.hasNext() && lRes == null; ) {
            XmlGroupTable lXmlGroupTable = iterator2.next();
            lRes = XmlGroupTable.findTableDetail(pDetailTypeId, lXmlGroupTable);
        }


        // result
        return lRes;
    }

    /**
     * return a table detail value (or its clone if indicated) corresponding to id passed. Null if not found
     *
     * @param pTableDetailIdContainingValueDetailed
     * @param pXmlGroupTabs
     * @param pCloneResult                          if true result is the clone, else it's the result its self
     * @return
     */
    public static XmlGroupTableDetailValue findTableDetailValueInTableDetail(String pTableDetailIdContainingValueDetailed, ArrayList<XmlGroupTab> pXmlGroupTabs, boolean pCloneResult) {

        // init
        XmlGroupTableDetailValue lRes = null;

        // search for
        XmlGroupTableDetail lDetail = XmlGroupTab.findTableDetail(pTableDetailIdContainingValueDetailed, pXmlGroupTabs, pCloneResult);
        if (lDetail != null && lDetail.getGroupTableDetailValues() != null && lDetail.getGroupTableDetailValues().size() >= 1) {
            // take the first value
            lRes = lDetail.getGroupTableDetailValues().get(0);
        }

        // result
        return lRes;
    }

    /**
     * return a list of detail values from codes
     *
     * @param pCodes        list of string codes
     * @param pXmlGroupTabs tab list to look for
     * @return
     */
    public static List<XmlGroupTableDetailValue> findTableDetailValuesByCodes(List<String> pCodes, ArrayList<XmlGroupTab> pXmlGroupTabs) {

        // init
        List<XmlGroupTableDetailValue> lRes = new ArrayList<>();

        // search for
        for (XmlGroupTab lXmlGroupTab : pXmlGroupTabs) {
            for (XmlGroupTable lXmlGroupTable : lXmlGroupTab.getGroupTables()) {
                lRes.addAll(lXmlGroupTable.findTableDetailValuesByCodes(pCodes));
            }
        }

        // result
        return lRes;
    }

    /**
     * adds a groupTable to groupTablelist
     *
     * @param pGroupTable
     */
    public void add(XmlGroupTable pGroupTable) {
        groupTables.add(pGroupTable);
    }

    /**
     * return true if tab is general tab, false else
     *
     * @return
     */
    public boolean isGeneralTab() {
        return type != null && type == XmlGroupType.TabGeneral.getId();
    }

    /**
     * return true if tab is empty, false else
     *
     * @return
     */
    public boolean isEmpty() {

        // init
        boolean lRes = true;

        // check tables
        if (groupTables != null && groupTables.size() > 0) {
            // table empty ?
            for (Iterator<XmlGroupTable> iterator = groupTables.iterator(); iterator.hasNext() && lRes; ) {
                XmlGroupTable lXmlGroupTable = iterator.next();

                if (!lXmlGroupTable.isEmpty()) {
                    lRes = false;
                }
            }
        }

        // if not empty -> check if contains indicator
        // -> if not consider it as empty
        if (!lRes) {
            lRes = (!containsIndicator());
        }

        // result
        return lRes;
    }

    /**
     * return true if tab contains indicator
     *
     * @return
     */
    public boolean containsIndicator() {

        //init
        boolean lRes = false;

        // check tables
        if (groupTables != null && groupTables.size() > 0) {
            // table empty ?
            for (Iterator<XmlGroupTable> iterator = groupTables.iterator(); iterator.hasNext() && !lRes; ) {
                XmlGroupTable lXmlGroupTable = iterator.next();

                if (lXmlGroupTable.containsIndicator()) {
                    lRes = true;
                }
            }
        }

        return lRes;
    }

    /**
     * try to replace vboth group in tab
     *
     * @param pXmlGroupDetailed
     * @param pXmlGroupToDetail
     */
    public void replaceBoth(XmlGroupTableDetailValue pXmlGroupDetailed, XmlGroupTableDetail pXmlGroupToDetail) {

        // loop on tables
        for (XmlGroupTable lXmlGroupTable : getGroupTables()) {
            lXmlGroupTable.replaceBoth(pXmlGroupDetailed, pXmlGroupToDetail);
        }
    }

    /**
     * Returns true if this tab contains the data code
     *
     * @param pDatum
     * @return
     */
    public boolean containsData(DataDto pDatum) {

        // init
        boolean lContains = false;

        if (groupTables != null) {
            for (Iterator<XmlGroupTable> iterator = groupTables.iterator(); iterator.hasNext() && !lContains; ) {
                XmlGroupTable lTable = iterator.next();
                lContains = lTable.containsData(pDatum);
            }
        }

        // result
        return lContains;
    }

    // Getters and setters

    public List<XmlGroupTable> getGroupTables() {
        return groupTables;
    }


}
