package fr.onema.sispea.struts.referential.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.DataDetailValueDto;
import fr.onema.sispea.service.data.DataValueDto;
import fr.onema.sispea.service.data.Reliability;
import fr.onema.sispea.service.data.VPValueDto;
import fr.onema.sispea.service.data.Verification;
import fr.onema.sispea.struts.referential.xml.XmlGroupType;


/**
 * This class is a support class to read xml group from a xml file for printing
 *
 * @author CS
 */
public class XmlDisplayGroup extends XmlGroup implements Cloneable {

    private static final long serialVersionUID = 1L;

    /**
     * the value
     */
    protected DataValueDto value = null;

    /**
     * the indicator name
     */
    protected String name = null;

    /**
     * the indicator unit
     */
    protected String unit = null;

    /**
     * the indicator reliability
     */
    protected Reliability reliability = null;

    /**
     * the indicator comment
     */
    protected String comment = null;

    /**
     * the indicator opinion
     */
    protected String opinion = null;

    /**
     * the indicator verification
     */
    protected Verification verification = null;

    /**
     * editing mode
     */
    protected Boolean editing = false;

    /**
     * visible mode
     */
    protected Boolean visible = true;

    /**
     * editable mode
     */
    protected Boolean editable = false;

    /**
     * auto compute formula
     */
    protected Boolean autoCompute = false;

    /**
     * Default constructor.
     */
    public XmlDisplayGroup() {
        super();
    }

    /**
     * copy constructor.
     */
    public XmlDisplayGroup(XmlGroup pXmlGroup) {
        super(pXmlGroup);
    }

    /**
     * clone an XmlDisplayGroup Object
     */
    public XmlDisplayGroup clone() {

        // init
        XmlDisplayGroup lRes = new XmlDisplayGroup();

        // copy attributs to the clone
        lRes.setAutoCompute(autoCompute);
        lRes.setCode(code);
        lRes.setComment(comment);
        lRes.setCompetence(competence);
        lRes.setEditing(editing);
        lRes.setId(id);
        lRes.setName(name);
        lRes.setOpinion(opinion);
        lRes.setReliability(reliability);
        lRes.setTitle(title);
        lRes.setType(type);
        lRes.setUnit(unit);
        if (value instanceof DataDetailValueDto) {
            DataDetailValueDto lVal = (DataDetailValueDto) value;
            lRes.setValue(lVal.clone());
        } else if (value instanceof VPValueDto) {
            VPValueDto lVal = (VPValueDto) value;
            lRes.setValue(lVal.clone());
        }

        lRes.setVerification(verification);

        // result
        return lRes;
    }

    public DataValueDto getValue() {
        return value;
    }

    public void setValue(VPValueDto pValue) {
        value = pValue;
    }

    public void setValue(DataValueDto pValue) {
        value = pValue;
    }

    public DataDetailValueDto getDetailValue() {
        return (DataDetailValueDto) value;
    }

    public void setValue(DataDetailValueDto pValue) {
        value = pValue;
    }

    public String getName() {
        return name;
    }

    public void setName(String pName) {
        name = pName;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String pUnit) {
        unit = pUnit;
    }

    public Reliability getReliability() {
        return reliability;
    }

    public void setReliability(Reliability pReliability) {
        reliability = pReliability;
    }

    public String getReliabilityName() {
        return reliability.name();
    }

    public void setReliabilityName(String pReliabilityName) throws SispeaException {
        reliability = Reliability.parse(pReliabilityName);
    }


    public String getComment() {
        return comment;
    }

    public void setComment(String pComment) {
        comment = pComment;
    }

    public Verification getVerification() {
        return verification;
    }

    public void setVerification(Verification pVerification) {
        verification = pVerification;
    }

    public boolean isVisibleIfPublished() {
        return (type.equals(XmlGroupType.DataIndicator.getId()));
    }

    public Boolean getEditing() {
        return editing;
    }

    public void setEditing(Boolean pEditing) {
        editing = pEditing;
    }

    public Boolean getAutoCompute() {
        return autoCompute;
    }

    public void setAutoCompute(Boolean autoCompute) {
        autoCompute = autoCompute;
    }

    public String getOpinion() {
        return opinion;
    }

    public void setOpinion(String pOpinion) {
        opinion = pOpinion;
    }

    public Boolean getVisible() {
        return visible;
    }

    public void setVisible(Boolean pVisible) {
        visible = pVisible;
    }

    public Boolean getEditable() {
        return editable;
    }

    public void setEditable(Boolean pEditable) {
        editable = pEditable;
    }
}
