package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.referential.bean.XmlGroupTab;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetail;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetailValue;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * This action show taxes of a SPEA.
 *
 * @author CS
 */
public class ShowTaxesEditorAction extends AbstractTaxesEditorAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowTaxesEditorAction.class);

    /**
     * Vp's codes to process
     */
    private static final List<String> VP_TO_PROCESS = Arrays.asList("VP.177", "VP.178");

    @Override
    protected String doExecute() throws Exception {
        // init result
        String lResult = SUCCESS;

        if (logger.isDebugEnabled()) {
            logger.debug("show price editor");
        }

        try {
            // Open menu according to the current JSP item.
            openMenu(MenuConstants.MENU_KEY_SPEA_INDICATORS);

            // check exercise
            checkExerciseParameter();

            // check if spea exists
            loadSpea(exercise);

            // get  xml groups from sispea session
            ArrayList<XmlGroupTab> lXmlGroupTabs = (ArrayList<XmlGroupTab>) getSispeaSession().getXmlGroups();

            // search for group detailed
            XmlGroupTableDetailValue lXmlGroupDetailed = XmlGroupTab.findTableDetailValueInTableDetail(xmlGroupTableDetailContainingValueDetailedId, lXmlGroupTabs, true);
            if (lXmlGroupDetailed == null) {
                throw new SispeaException("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.noGroupDetailed");
            }

            // search for group detailed
            XmlGroupTableDetail lXmlGroupToDetail = XmlGroupTab.findTableDetail(xmlGroupTableDetailToDetailId, lXmlGroupTabs, true);
            if (lXmlGroupToDetail == null) {
                throw new SispeaException("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.noGroupToDetail");
            }

            // we also need VP.177 and VP.178 group
            List<XmlGroupTableDetailValue> lDetailValues = XmlGroupTab.findTableDetailValuesByCodes(VP_TO_PROCESS, lXmlGroupTabs);
            if (lDetailValues == null) {
                throw new SispeaException("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.noContextGroup");
            }

            // add current xmlDisplayGroup to session
            getSispeaSession().setXmlCurrentContextGroup(lDetailValues);
            getSispeaSession().setXmlCurrentGroupDetailed(lXmlGroupDetailed);
            getSispeaSession().setXmlCurrentGroupToDetail(lXmlGroupToDetail);

            // in the Detail detailed, a simple detail value contains the value detailed
            code = lXmlGroupDetailed.getCode();
            detailType = lXmlGroupDetailed.getType();

        } catch (SispeaException lEx) {
            lResult = Action.INPUT;
            addActionError(getText("fr.onema.sispea.referential.action.showSpeaIndicators.error.common", "", getText(lEx.getMessage())));
        }

        // result
        return lResult;
    }

}
