package fr.onema.sispea.struts.exchange.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.service.user.UserDto;
import org.apache.log4j.Logger;

/**
 * This action confirms the add of the data in the uploaded file.
 * It allows the end user to upload data and referential.
 *
 * The action takes the name of the file as a parameter.
 *
 * @author CS
 */
public class SubmitFileAction extends AbstractFileUploadAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(SubmitFileAction.class);

    /**
     * The name of the file to submit.
     */
    protected Integer file;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("Submitting the uploaded file");
        }

        // Get the current user
        UserDto currentUser = getSispeaSession().getUser();

        // Use the service to insert the data in the file
        //
        // The submit is handled asynchronously
        fileExchangeService.submitUploadedFile(currentUser, getLocale().getLanguage(), file);

        if (logger.isDebugEnabled()) {
            logger.info("File has been submitted.");
        }

        return Action.SUCCESS;
    }

    public void setFile(Integer pIndex) {
        file = pIndex;
    }
}
