package fr.onema.sispea.struts.exchange.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;


/**
 * This action initializes the file uploading.
 * It allows the end user to upload data and referential.
 *
 * @author CS
 */
public class InitFileUploadAction extends AbstractFileUploadAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(InitFileUploadAction.class);

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("Initializing file upload");
        }

        // Nothing to do but menu
        openMenu(MenuConstants.MENU_KEY_SENDDATA);

        return Action.SUCCESS;
    }

    /**
     * Always false.
     * Returns true if the file has been validated, but as this is never the case when
     * this action is called the return value will always be false.
     */
    public boolean isValidated() {
        return false;
    }
}
