package fr.onema.sispea.struts.common.menu;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.struts.common.bean.MenuBean;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.log4j.Logger;

import java.io.InputStream;
import java.net.URL;

/**
 * This class is a support class to read the incoming files.
 *
 * @author CS
 */
public class MenuReader {

    private static final Logger logger = Logger.getLogger(MenuReader.class);

    /**
     * This method parses the file pFile
     *
     * @param pMenufileInClasspath The file to parse. The parameter gives the absolute classpath location of the file.
     * @throws SispeaException
     */
    public MenuBean parse(String pMenufileInClasspath) throws SispeaException {
        try {
            // Create a digester
            URL ruleFile = getUrl("/fr/onema/sispea/struts/common/menu/menuRules.xml");
            Digester digester = DigesterLoader.createDigester(ruleFile);

            MenuBean rootMenu = new MenuBean();
            rootMenu.setKey("root");
            digester.push(rootMenu);

            // Open menu xml file
            InputStream menuStream = getClass().getResourceAsStream(pMenufileInClasspath);

            // Parse the file
            rootMenu = (MenuBean) digester.parse(menuStream);
            if ((logger.isDebugEnabled()) && (rootMenu == null)) {
                logger.debug("root menu is null !!");
            }

            return rootMenu;
        } catch (Exception e) {
            String msg = "Error while parsing uploaded file: " + pMenufileInClasspath;
            logger.error(msg, e);
            throw new SispeaException(msg, e);
        }
    }

    /**
     * This method returns the URL of the file pName.
     * pName must be the access path in the classpath to the file.
     * URL returned is validated.
     *
     * @param pName Access path in the classpath to the file
     * @return The URL to access the file.
     * @throws SispeaException If the file pName can not be accessed.
     */
    protected URL getUrl(String pName) throws SispeaException {

        URL url = getClass().getResource(pName);

        // Test that the url is valid and a file
        if (url == null) {
            // Cannot find the file in the classpath
            String msg = "Cannot find the file in the classpath: " + pName;
            logger.error(msg);
            throw new SispeaException(msg);
        }
        return url;
    }

}
