/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.ActivityLongline;
import fr.ird.observe.entities.longline.Branchline;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.impl.longline.BranchlineUI;
import fr.ird.observe.ui.content.impl.longline.BranchlineUIModel;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;

public class BranchlineUIHandler
extends ContentUIHandler<Branchline> {
    private static Log log = LogFactory.getLog(BranchlineUIHandler.class);
    private Decorator<Branchline> branchlineDecorator;

    public BranchlineUIHandler(BranchlineUI ui) {
        super(ui, DataContextType.SetLongline, null);
    }

    public void edit(Branchline branchline) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will edit branchline: " + this.branchlineDecorator.toString((Object)branchline)));
        }
        this.getModel().setBranchline(branchline);
        this.getLoadBinder().copy((Object)branchline, this.getBean(), new String[0]);
        if (branchline == null) {
            this.stopEditUI();
        } else if (this.getModel().isEnabled() && !this.getModel().isEditing()) {
            this.startEditUI(new String[0]);
        }
        this.getModel().setModified(false);
    }

    public BranchlineUIModel getModel() {
        return (BranchlineUIModel)super.getModel();
    }

    public BranchlineUI getUi() {
        return (BranchlineUI)super.getUi();
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        ContentMode contentMode = dataContext.isSelectedOpen(ActivityLongline.class) ? ContentMode.UPDATE : ContentMode.READ;
        return contentMode;
    }

    @Override
    public void initUI() throws Exception {
        this.branchlineDecorator = this.getDecoratorService().getDecoratorByType(Branchline.class);
        super.initUI();
    }

    @Override
    public void openUI() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("OpenUI: " + (Object)((Object)this.getModel())));
        }
        boolean canWrite = this.computeCanWrite(this.getDataSource());
        this.getModel().setCanWrite(canWrite);
        this.updateActions();
        ContentMode mode = this.computeContentMode();
        this.setContentMode(mode);
        this.edit(null);
        if (mode != ContentMode.READ) {
            this.ui.startEdit(null);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        BranchlineUIModel model = this.getModel();
        super.startEditUI("comment2.text", "topType.selectedItem", "tracelineType.selectedItem", "depthRecorder.selected", "hookLost.selected", "traceCutOff.selected", "weightedSwivel.selected", "swivelWeight.model", "weightedSnap.selected", "snapWeight.model", "baitType.selectedItem", "baitSettingStatus.selectedItem", "topBaitSettingStatus.selectedItem", "tracelineBaitSettingStatus.selectedItem", "baitHaulingStatus.selectedItem", "hookType.selectedItem", "hookSize.selectedItem", "hookOffset.model", "timer.selected", "timeSinceContact.model", "timerTimeOnBoard.date");
        model.setModified(false);
    }

    @Override
    protected boolean doSave(Branchline bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<Branchline> binder) throws Exception {
        Branchline beanToSave = this.getModel().getBranchline();
        binder.copy((Object)bean, (Object)beanToSave, new String[0]);
        this.getModel().fireSaved();
        return true;
    }

    @Override
    public void resetEditUI() {
        Branchline branchline = this.getModel().getBranchline();
        this.stopEditUI();
        try {
            this.openUI();
        }
        catch (Exception ex) {
            ErrorDialogUI.showError((Exception)ex);
            if (log.isErrorEnabled()) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
            this.stopEditUI();
        }
        this.edit(branchline);
    }

    public boolean tryToQuit() {
        boolean canContinue;
        if (this.getModel().isEditing() && this.getModel().isModified()) {
            canContinue = false;
            if (this.getModel().isValid()) {
                int reponse = UIHelper.askUser(I18n.t((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n.t((String)"observe.branchline.message.modified", (Object[])new Object[0]), 2, new Object[]{I18n.t((String)"observe.choice.save", (Object[])new Object[0]), I18n.t((String)"observe.choice.doNotSave", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("response : " + reponse));
                }
                switch (reponse) {
                    case -1: 
                    case 2: {
                        break;
                    }
                    case 0: {
                        this.saveUI(false);
                        canContinue = true;
                        break;
                    }
                    case 1: {
                        this.resetEditUI();
                        canContinue = true;
                    }
                }
            } else {
                int reponse = UIHelper.askUser(I18n.t((String)"observe.title.need.confirm", (Object[])new Object[0]), I18n.t((String)"observe.branchline.message.modified.but.invalid", (Object[])new Object[0]), 0, new Object[]{I18n.t((String)"observe.choice.continue", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("response : " + reponse));
                }
                switch (reponse) {
                    case 0: {
                        this.resetEditUI();
                        canContinue = true;
                    }
                }
            }
        } else {
            canContinue = true;
        }
        return canContinue;
    }
}

