/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl;

import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.entities.Calee;
import fr.ird.observe.entities.EchantillonThon;
import fr.ird.observe.entities.TailleThon;
import fr.ird.observe.entities.referentiel.EspeceThon;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.impl.EchantillonThonUI;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EchantillonThonUIHandler
extends ContentTableUIHandler<EchantillonThon, TailleThon> {
    private static Log log = LogFactory.getLog(EchantillonThonUIHandler.class);

    static ContentTableUIModel<EchantillonThon, TailleThon> newModel(EchantillonThonUI ui) {
        return new ContentTableUIModel<EchantillonThon, TailleThon>(EchantillonThon.class, TailleThon.class, new String[]{"tailleThon", "commentaire"}, new String[]{"echantillonThon", "espece", "longueur", "effectif"}, ui, ContentTableModel.newTableMeta(TailleThon.class, "espece", true), ContentTableModel.newTableMeta(TailleThon.class, "longueur", true), ContentTableModel.newTableMeta(TailleThon.class, "effectif", false));
    }

    public EchantillonThonUIHandler(EchantillonThonUI ui) {
        super(ui);
    }

    @Override
    public EchantillonThonUI getUi() {
        return (EchantillonThonUI)super.getUi();
    }

    @Override
    protected EchantillonThon loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        if (mode == ContentMode.UPDATE) {
            String caleeId = dataContext.getSelectedCaleeId();
            List especes = dataService.getAvailableEspeceForEchantillonThon(dataSource, caleeId);
            this.getUi().getEspece().setData(especes);
        }
        return (EchantillonThon)super.loadEditBean(mode, dataContext, dataService, dataSource);
    }

    @Override
    protected boolean prepareSave(EchantillonThon bean, List<TailleThon> objets) {
        for (TailleThon tailleThon : objets) {
            tailleThon.setEchantillonThon(bean);
        }
        return true;
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, TailleThon bean, boolean create) {
        EntityComboBox<EspeceThon> requestFocus;
        ContentTableModel model = this.getTableModel();
        EchantillonThonUI ui = this.getUi();
        if (!model.isEditable()) {
            return;
        }
        EspeceThon espece = bean.getEspece();
        if (create) {
            if (model.isCreate() && editingRow > 0) {
                model.getValueAt(editingRow - 1);
                espece = ((TailleThon)model.getValueAt(editingRow - 1)).getEspece();
            }
            requestFocus = ui.getEspece();
        } else {
            requestFocus = ui.getEffectif();
        }
        ui.getEspece().setSelectedItem(null);
        if (espece != null) {
            log.debug((Object)("espece to use " + espece));
            ui.getEspece().setSelectedItem((Object)espece);
        }
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n_((String)"observe.table.echantillonThon.especeThon"), I18n.n_((String)"observe.table.echantillonThon.especeThon.tip"), I18n.n_((String)"observe.table.echantillonThon.longueur"), I18n.n_((String)"observe.table.echantillonThon.longueur.tip"), I18n.n_((String)"observe.table.echantillonThon.effectif"), I18n.n_((String)"observe.table.echantillonThon.effectif.tip")});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, EspeceThon.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        ContentMode mode = super.getContentMode(dataContext);
        if (mode != ContentMode.UPDATE) {
            return mode;
        }
        boolean canEdit = false;
        try {
            String caleeId = this.getDataContext().getSelectedCaleeId();
            canEdit = this.getDataService().canUseEchantillonThon(this.getDataSource(), caleeId);
        }
        catch (DataSourceException e) {
            log.error((Object)e);
        }
        if (!canEdit) {
            mode = ContentMode.READ;
            EchantillonThonUIHandler.addMessage(this.ui, BeanValidatorScope.INFO, this.getEntityLabel(Calee.class), I18n._((String)"observe.message.calee.no.rejetThon"));
        }
        return mode;
    }
}

