/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.ObjetFlottant;
import fr.ird.observe.entities.ObjetFlottantDAO;
import fr.ird.observe.entities.referentiel.OperationObjet;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.impl.ObjetFlottantUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.Deletor;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderBuilder;

public class ObjetFlottantUIHandler
extends ContentUIHandler<ObjetFlottant> {
    private static Log log = LogFactory.getLog(ObjetFlottantUIHandler.class);

    public ObjetFlottantUIHandler(ObjetFlottantUI ui) {
        super(ui);
    }

    public ObjetFlottantUI getUi() {
        return (ObjetFlottantUI)super.getUi();
    }

    @Override
    protected TopiaEntityBinder<ObjetFlottant> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(ObjetFlottant.class, binderName);
        if (r == null) {
            BinderBuilder builder = new BinderBuilder(ObjetFlottant.class, new String[]{"type", "devenir", "operation", "appartenance", "commentaire", "nomSupply", "nbJourEau"});
            r = binderService.registerTopiaBinder(ObjetFlottant.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String dcpId = dataContext.getSelectedObjetFlottantId();
        if (dcpId == null) {
            return ContentMode.CREATE;
        }
        if (dataContext.isSelectedOpen(Activite.class)) {
            return ContentMode.UPDATE;
        }
        ObjetFlottantUIHandler.addMessage(this.ui, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.activite.not.open"));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        DataContext openableContext = this.getDataContext();
        String activiteId = openableContext.getSelectedActiviteId();
        String dcpId = openableContext.getSelectedObjetFlottantId();
        log.info((Object)("activiteId = " + activiteId));
        log.info((Object)("dcpId      = " + dcpId));
        ContentMode mode = this.prepareContentMode();
        ObjetFlottant bean = (ObjetFlottant)this.getBean();
        DataService dataService = this.getDataService();
        if (dcpId == null) {
            dataService.preCreateEntity(this.getDataSource(), activiteId, (TopiaEntity)bean, this.getOpeningBinder(), this.getPreCreateExecutor());
        } else {
            dataService.loadEditEntity(this.getDataSource(), dcpId, this.getOpeningExecutor());
        }
        this.getModel().setMode(mode);
        if (mode != ContentMode.READ) {
            this.ui.startEdit(null);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        boolean create = this.getModel().getMode() == ContentMode.CREATE;
        String contextName = this.getValidatorContextName(this.getModel().getMode());
        this.getUi().getValidator().setContextName(contextName);
        if (create) {
            ObjetFlottantUIHandler.addMessage(this.ui, BeanValidatorScope.INFO, this.getEntityLabel(ObjetFlottant.class), I18n._((String)"observe.message.creating.objetFlottant"));
        } else {
            ObjetFlottantUIHandler.addMessage(this.ui, BeanValidatorScope.INFO, this.getEntityLabel(ObjetFlottant.class), I18n._((String)"observe.message.updating.objetFlottant"));
        }
        super.startEditUI("nbJourEau.model", "type.selectedItem", "devenir.selectedItem", "nomSupply.text", "commentaire2.text", "appartenance.selectedIndex");
        this.getModel().setModified(create);
    }

    @Override
    protected boolean doSave(ObjetFlottant bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<ObjetFlottant> binder) throws Exception {
        String activiteId = this.getDataContext().getSelectedActiviteId();
        if (bean.getTopiaId() == null) {
            dataService.create(dataSource, activiteId, (TopiaEntity)bean, binder, this.getCreateExecutor());
        } else {
            dataService.update(dataSource, (TopiaEntity)bean, binder, new String[0]);
        }
        return true;
    }

    @Override
    protected boolean doDelete(ObjetFlottant bean, DataService dataService, DataSource dataSource, Deletor<Object, ObjetFlottant> deletor) throws Exception {
        if (!UIHelper.confirmForEntityDelete(this.ui, ObjetFlottant.class, bean)) {
            return false;
        }
        if (bean.getTopiaId() != null) {
            String activiteId = this.getDataContext().getSelectedActiviteId();
            dataService.delete(dataSource, activiteId, (TopiaEntity)bean, deletor);
        }
        return true;
    }

    @Override
    protected ObjetFlottant onCreate(TopiaContext tx, Object parent, ObjetFlottant bean) throws TopiaException {
        Activite parentBean = (Activite)parent;
        ObjetFlottantDAO flottantDAO = ObserveDAOHelper.getObjetFlottantDAO((TopiaContext)tx);
        ObjetFlottant beanToSave = (ObjetFlottant)flottantDAO.create(new Object[0]);
        bean.setTopiaId(beanToSave.getTopiaId());
        parentBean.addObjetFlottant(beanToSave);
        return beanToSave;
    }

    @Override
    protected void onDelete(TopiaContext tx, Object parent, ObjetFlottant bean) {
        Activite parentBean = (Activite)parent;
        parentBean.removeObjetFlottant(bean);
    }

    @Override
    protected void afterSave(boolean refresh) {
        boolean create;
        ObjetFlottant bean = (ObjetFlottant)this.getBean();
        BeanValidatorUtil.setValidatorChanged((JAXXObject)this.ui, (boolean)false, (String[])new String[0]);
        ObserveTreeHelper treeHelper = ObjetFlottantUIHandler.getTreeHelper((JAXXContext)this.ui);
        ObserveNode node = (ObserveNode)treeHelper.getSelectedNode();
        boolean bl = create = node.getId() == null;
        if (create) {
            this.getModel().setMode(ContentMode.UPDATE);
            ObserveNode parentNode = (ObserveNode)treeHelper.removeNode((NavNode)node);
            node = treeHelper.addObjetFlottant(parentNode, bean);
            this.stopEditUI();
            if (refresh) {
                treeHelper.selectNode((NavNode)node);
            }
        } else {
            treeHelper.refreshNode((NavNode)node, false);
        }
    }

    public void selectOperations(ObjetFlottant bean, Object[] selected) {
        boolean update;
        boolean bl = update = selected.length != bean.sizeOperation();
        if (!update && selected.length > 0) {
            Collection list = bean.getOperation();
            for (Object o : selected) {
                if (list.contains(o)) continue;
                update = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(selected.length + " do update ? " + update));
        }
        if (update) {
            ListSelectionModel selectionModel = this.getUi().getOperation().getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            ArrayList<OperationObjet> newList = new ArrayList<OperationObjet>(selected.length);
            for (Object o : selected) {
                newList.add((OperationObjet)o);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("update operations " + newList.size()));
            }
            bean.setOperation(newList);
            selectionModel.setValueIsAdjusting(false);
        }
    }
}

