/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.admin.AdminActionModel;
import fr.ird.observe.ui.admin.AdminTabUI;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.config.ConfigUI;
import fr.ird.observe.ui.admin.export.ExportModel;
import fr.ird.observe.ui.admin.export.ExportUI;
import fr.ird.observe.ui.admin.export.SelectExportDataUI;
import fr.ird.observe.ui.admin.gps.ImportGPSModel;
import fr.ird.observe.ui.admin.gps.ImportGPSUI;
import fr.ird.observe.ui.admin.report.ReportModel;
import fr.ird.observe.ui.admin.report.ReportUI;
import fr.ird.observe.ui.admin.report.SelectReportDataUI;
import fr.ird.observe.ui.admin.resume.ShowResumeUI;
import fr.ird.observe.ui.admin.save.SaveLocalModel;
import fr.ird.observe.ui.admin.save.SaveLocalUI;
import fr.ird.observe.ui.admin.synchronize.SynchronizeModel;
import fr.ird.observe.ui.admin.synchronize.SynchronizeUI;
import fr.ird.observe.ui.admin.validate.SelectValidateDataUI;
import fr.ird.observe.ui.admin.validate.ValidateModel;
import fr.ird.observe.ui.admin.validate.ValidateUI;
import java.lang.reflect.Constructor;
import java.util.EnumSet;
import javax.swing.ImageIcon;
import jaxx.runtime.swing.wizard.ext.WizardExtStep;
import jaxx.runtime.swing.wizard.ext.WizardExtUI;
import org.nuiton.i18n.I18n;

public enum AdminStep implements WizardExtStep
{
    CONFIG(I18n.n_((String)"observe.synchro.step.config"), I18n.n_((String)"observe.synchro.step.config.description"), null, ConfigUI.class, true),
    SELECT_VALIDATE_DATA(I18n.n_((String)"observe.synchro.step.selectValidateData"), I18n.n_((String)"observe.synchro.step.selectValidateData.description"), ValidateModel.class, SelectValidateDataUI.class, true),
    SELECT_EXPORT_DATA(I18n.n_((String)"observe.synchro.step.selectExportData"), I18n.n_((String)"observe.synchro.step.selectExportData.description"), ExportModel.class, SelectExportDataUI.class, true),
    SELECT_REPORT_DATA(I18n.n_((String)"observe.synchro.step.selectReportData"), I18n.n_((String)"observe.synchro.step.selectReportData.description"), ReportModel.class, SelectReportDataUI.class, true),
    SYNCHRONIZE(I18n.n_((String)"observe.synchro.step.synchronize"), I18n.n_((String)"observe.synchro.step.synchronize.description"), I18n.n_((String)"observe.title.synchronize"), I18n.n_((String)"observe.title.synchronize.tip"), "synchronizeReferentiel", I18n.n_((String)"observe.synchro.operation.synchronize"), I18n.n_((String)"observe.synchro.operation.synchronize.description"), SynchronizeModel.class, SynchronizeUI.class, true, true, false),
    VALIDATE(I18n.n_((String)"observe.synchro.step.validate"), I18n.n_((String)"observe.synchro.step.validate.description"), I18n.n_((String)"observe.title.validate"), I18n.n_((String)"observe.title.validate.tip"), "validate", I18n.n_((String)"observe.synchro.operation.validate"), I18n.n_((String)"observe.synchro.operation.validate.description"), ValidateModel.class, ValidateUI.class, false, false, false),
    REPORT(I18n.n_((String)"observe.synchro.step.report"), I18n.n_((String)"observe.synchro.step.report.description"), I18n.n_((String)"observe.title.report"), I18n.n_((String)"observe.title.report.tip"), "report", I18n.n_((String)"observe.synchro.operation.report"), I18n.n_((String)"observe.synchro.operation.report.description"), ReportModel.class, ReportUI.class, false, false, false),
    IMPORT_GPS(I18n.n_((String)"observe.synchro.step.importGPS"), I18n.n_((String)"observe.synchro.step.importGPS.description"), I18n.n_((String)"observe.title.importGPS"), I18n.n_((String)"observe.title.importGPS.tip"), "importGPS", I18n.n_((String)"observe.synchro.operation.importGPS"), I18n.n_((String)"observe.synchro.operation.importGPS.description"), ImportGPSModel.class, ImportGPSUI.class, false, false, false),
    SAVE_LOCAL(I18n.n_((String)"observe.synchro.step.saveLocal"), I18n.n_((String)"observe.synchro.step.saveLocal.description"), null, null, "save", I18n.n_((String)"observe.synchro.operation.saveLocal"), I18n.n_((String)"observe.synchro.operation.saveLocal.description"), SaveLocalModel.class, SaveLocalUI.class, false, false, false),
    EXPORT_DATA(I18n.n_((String)"observe.synchro.step.exportData"), I18n.n_((String)"observe.synchro.step.exportData.description"), I18n.n_((String)"observe.title.exportData"), I18n.n_((String)"observe.title.exportData.tip"), "remote-export", I18n.n_((String)"observe.synchro.operation.exportData"), I18n.n_((String)"observe.synchro.operation.exportData.description"), ExportModel.class, ExportUI.class, true, false, false),
    SHOW_RESUME(I18n.n_((String)"observe.synchro.step.showResume"), I18n.n_((String)"observe.synchro.step.showResume.description"), null, ShowResumeUI.class, false);

    private final String iconName;
    private final String title;
    private final String titleTip;
    private final String label;
    private final String description;
    private final String operationLabel;
    private final String operationDescription;
    private final Class<? extends AdminActionModel> modelClass;
    private final Class<? extends AdminTabUI> uiClass;
    private final boolean needReferentiel;
    private final boolean needSave;
    private final boolean config;
    private transient ImageIcon icon;

    public static EnumSet<AdminStep> getOperations() {
        EnumSet<AdminStep> operations = EnumSet.noneOf(AdminStep.class);
        for (AdminStep step : AdminStep.values()) {
            if (!step.isOperation()) continue;
            operations.add(step);
        }
        return operations;
    }

    private AdminStep(String label, String description, Class<? extends AdminActionModel> modelClass, Class<? extends AdminTabUI> uiClass, boolean config) {
        this(label, description, null, null, null, null, null, modelClass, uiClass, false, false, config);
    }

    private AdminStep(String label, String description, String title, String titleTip, String iconName, String operationLabel, String operationDescription, Class<? extends AdminActionModel> modelClass, Class<? extends AdminTabUI> uiClass, boolean needReferentiel, boolean needSave, boolean config) {
        this.label = label;
        this.description = description;
        this.title = title;
        this.titleTip = titleTip;
        this.iconName = iconName;
        this.operationDescription = operationDescription;
        this.operationLabel = operationLabel;
        this.needReferentiel = needReferentiel;
        this.needSave = needSave;
        this.modelClass = modelClass;
        this.uiClass = uiClass;
        this.config = config;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleTip() {
        return this.titleTip;
    }

    public String getIconName() {
        return this.iconName;
    }

    public ImageIcon getIcon() {
        if (this.iconName != null && this.icon == null) {
            this.icon = (ImageIcon)UIHelper.getUIManagerActionIcon((String)this.iconName);
        }
        return this.icon;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOperationDescription() {
        return this.operationDescription;
    }

    public String getOperationLabel() {
        return this.operationLabel;
    }

    public boolean isOperation() {
        return this.operationLabel != null;
    }

    public boolean isConfig() {
        return this.config;
    }

    public Class<? extends AdminActionModel> getModelClass() {
        return this.modelClass;
    }

    public Class<? extends AdminTabUI> getUiClass() {
        return this.uiClass;
    }

    public AdminActionModel newModel() {
        if (!this.isOperation()) {
            throw new IllegalStateException("The current step [" + (Object)((Object)this) + "] is not an operation.");
        }
        try {
            return this.getModelClass().newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not init model : " + this.getModelClass(), e);
        }
    }

    public AdminTabUI newUI(WizardExtUI<?, ?> ui) {
        try {
            Constructor<? extends AdminTabUI> constructor = this.uiClass.getConstructor(AdminUI.class);
            AdminTabUI tabPanelUI = constructor.newInstance(ui);
            return tabPanelUI;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not init ui " + (Object)((Object)this), e);
        }
    }

    public boolean isNeedReferentiel() {
        return this.needReferentiel;
    }

    public boolean isNeedSave() {
        return this.needSave;
    }

    public static AdminStep valueOfIgnoreCase(String value) {
        for (AdminStep step : AdminStep.values()) {
            if (!step.name().equalsIgnoreCase(value)) continue;
            return step;
        }
        return null;
    }
}

