/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: AbstractMappedGridDataSource.java 1059 2011-03-11 17:30:31Z bleny $
 * $HeadURL: http://svn.forge.codelutin.com/svn/wao/tags/wao-3.2.1/wao-ui/src/main/java/fr/ifremer/wao/ui/data/AbstractMappedGridDataSource.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.WaoException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.SortConstraint;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * ContactDataSource
 *
 * Created: 18 janv. 2010
 *
 * @param <K> Type of the map key
 * @param <E> Type of the map value
 * @author fdesbois <fdesbois@codelutin.com>
 */
public abstract class AbstractMappedGridDataSource<K, E extends TopiaEntity> implements GridDataSource {


    private Logger log = LoggerFactory.getLogger(AbstractMappedGridDataSource.class);

    private Map<K, E> mapResults;

    private List<E> listResults;

    private int nbRows = -1;

    private int nbRowsPerPage;

    @Override
    public int getAvailableRows() {
        if (nbRows < 0) {
            try {
                nbRows = count();
                if (log.isTraceEnabled()) {
                    log.trace("Count : " + nbRows);
                }
            } catch (WaoException eee) {
                throw new TapestryException("", eee);
            }
        }
        return nbRows;
    }

    @Override
    public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
        if (log.isTraceEnabled()) {
            log.trace("Prepare results : " + startIndex + ", " + endIndex);
        }
        nbRowsPerPage = endIndex - startIndex + 1;
        try {
            mapResults = execute(startIndex, endIndex, getSortConstraint(sortConstraints));
            listResults = new ArrayList<E>(mapResults.values());

            // FIXME manage sort columnsForImport in execute ???? seems obvious --> needed for Contacts, done for Boats
            //sortResults(sortConstraints);
        } catch (WaoException eee) {
            throw new TapestryException("", eee);
        }
    }

    protected abstract Map<K, E> execute(int startIndex, int endIndex, 
            SortConstraint orderBy) throws WaoException;

    protected abstract int count() throws WaoException;

    protected SortConstraint getSortConstraint(List<SortConstraint> sortConstraints) {
        for (SortConstraint constraint : sortConstraints)
        {
            final ColumnSort sort = constraint.getColumnSort();

            if (sort != ColumnSort.UNSORTED) {
                return constraint;
            }
        }
        return null;
    }

//    protected void sortResults(List<SortConstraint> sortConstraints) {
//
//        for (SortConstraint constraint : sortConstraints)
//        {
//            final ColumnSort sort = constraint.getColumnSort();
//
//            if (sort == ColumnSort.UNSORTED) continue;
//
//            final PropertyConduit conduit = constraint.getPropertyModel().getConduit();
//
//            final Comparator valueComparator = new Comparator<Comparable>()
//            {
//                public int compare(Comparable o1, Comparable o2)
//                {
//                    // Simplify comparison, and handle case where both are nulls.
//
//                    if (o1 == o2) return 0;
//
//                    if (o2 == null) return 1;
//
//                    if (o1 == null) return -1;
//
//                    return o1.compareTo(o2);
//                }
//            };
//
//            final Comparator rowComparator = new Comparator()
//            {
//                public int compare(Object row1, Object row2)
//                {
//                    Comparable value1 = (Comparable) conduit.get(row1);
//                    Comparable value2 = (Comparable) conduit.get(row2);
//
//                    return valueComparator.compare(value1, value2);
//                }
//            };
//
//            final Comparator reverseComparator = new Comparator()
//            {
//                public int compare(Object o1, Object o2)
//                {
//                    int modifier = sort == ColumnSort.ASCENDING ? 1 : -1;
//
//                    return modifier * rowComparator.compare(o1, o2);
//                }
//            };
//
//            // We can freely sort this list because its just a copy.
//
//            Collections.sort(listResults, reverseComparator);
//        }
//    }

    @Override
    public Object getRowValue(int index) {
        index = index % nbRowsPerPage;
        if (index >= listResults.size()) {
            if (log.isErrorEnabled()) {
                log.error("Size error : " + index + " / " + listResults.size());
            }
            return null;
        }
        return CollectionUtils.get(listResults, index);
    }

    @Override
    public abstract Class<?> getRowType();

    public E get(K key) {
        if (mapResults == null) {
            return null;
        }
        return mapResults.get(key);
    }

    public List<E> values() {
        if (listResults == null) {
            listResults = new ArrayList<E>();
        }
        return listResults;
    }

    public boolean contains(K key) {
        if (mapResults == null) {
            return false;
        }
        return mapResults.containsKey(key);
    }

}
