/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterValues;
import fr.ifremer.wao.service.ServiceSampling;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Persist;
import org.nuiton.util.PeriodDates;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class SamplingFilterComponent extends FilterComponent<SamplingFilter> {

    @Parameter(required = false)
    private Boolean showEstimatedTides;

    @Parameter(required = true)
    private String legendMsg;

    /*
    * Services
    */
    @Parameter(required = true)
    private ServiceSampling serviceSampling;

    /*
     * Datas
     */
    @Persist
    private SamplingFilterValues possibleValuesForFilter;

    @Persist
    private boolean initFlag;

    @Override
    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    @Override
    public Boolean getFiltersVisible() {

        // If visible on startup
        Boolean filtersVisible = super.getFiltersVisible();
        if (filtersVisible == null) {
            filtersVisible = getVisibleOnStartup();

            // If somthing is selected
            if (!filtersVisible) {
                filtersVisible = !getFilter().isPeriodFilteredOnly();
            }
        }

        return filtersVisible;
    }

    @Override
    public void resetFilter() {
        // Don't reset period in filters
        PeriodDates period = null;
        if (initFlag) {
            SamplingFilter filter = getFilter();
            period = (filter == null ? null : filter.getPeriod());
        } else {
            initFlag = true;
        }
        setFilter(serviceSampling.newSamplingFilter(getUser()));

        if (period != null) {
            getFilter().setPeriod(period);
        }
    }

    @Override
    public void updateSearchFields() {
        updatePossibleValuesForFilter();
    }

    public SamplingFilterValues getPossibleValuesForFilter() {
        return getPossibleValuesForFilter(false);
    }

    public SamplingFilterValues updatePossibleValuesForFilter() {
        return getPossibleValuesForFilter(true);
    }

    protected SamplingFilterValues getPossibleValuesForFilter(boolean update) {
        if (update || possibleValuesForFilter == null) {
            possibleValuesForFilter = serviceSampling.getPossibleValuesForFilter(getFilter());
        }
        return possibleValuesForFilter;
    }

    // False by default
    public Boolean getShowEstimatedTides() {
        if (showEstimatedTides == null) {
            showEstimatedTides = false;
        }
        return showEstimatedTides;
    }

    public String getLegendMsg() {
        return legendMsg;
    }

    public String getFormatForPeriod() {
        String format;
        if (getUser().isObsDeb()) {
            format = "dd/MM/yyyy";
        } else {
            format = "MM/yyyy";
        }
        return format;
    }
}
