/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.base;

import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterValues;
import fr.ifremer.wao.service.ServiceSampling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public abstract class FilterManager<E extends SamplingFilter> {

    /**
     * Logger.
     */
    private static final Logger log = LoggerFactory.getLogger(FilterManager.class);

    protected ConnectedUser user;

    /*
     * Services
     */
    protected ServiceSampling serviceSampling;

    /*
     * Datas
     */
    protected SamplingFilterValues possibleValuesForFilter;

    public FilterManager(ConnectedUser user,
                         ServiceSampling serviceSampling) {

        this.serviceSampling = serviceSampling;
        this.user = user;

        // Initialize filter
        resetFilter();
    }

    public SamplingFilterValues getPossibleValuesForFilter() {
        return getPossibleValuesForFilter(false);
    }

    public SamplingFilterValues updatePossibleValuesForFilter() {
        return getPossibleValuesForFilter(true);
    }

    protected SamplingFilterValues getPossibleValuesForFilter(boolean update) {
        if (update || possibleValuesForFilter == null) {
            possibleValuesForFilter = serviceSampling.getPossibleValuesForFilter(getFilter());
        }
        return possibleValuesForFilter;
    }

    public ConnectedUser getUser() {
        return user;
    }
    public void initCompagnyFilter() {
        // Very very important to do that at beginning
        // Evo #2227 : Guest user has no default company filter
        if (user.isCoordinatorOrObserver()) {
            if (log.isDebugEnabled()) {
                log.debug("Company filtered : " + user.getCompany().getName());
            }
            getFilter().setCompany(user.getCompany());
        }
    }

    public abstract E getFilter();

    /**
     * Method to initialize filter, is call on constructor
     */
    public abstract void resetFilter();

    /**
     * Used to show only active company and observers.
     *
     * @return true if only active users will be showed, false otherwise
     */
    protected abstract boolean isAvailableDataForFiltersOnly();

    public void updateSearchFields() {
        updatePossibleValuesForFilter();
    }
}
