/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.service.ServiceCartography;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.data.KmlStreamResponse;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.SessionState;

import java.io.IOException;

/**
 * Created: 8 juil. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id$
 */
public class KmlLoaderStrategyContacts implements KmlLoaderStrategy<ContactFilter> {

    protected ServiceCartography serviceCartography;

    protected ServiceUser serviceUser;

    public KmlLoaderStrategyContacts(ServiceCartography serviceCartography,
                                     ServiceUser serviceUser) {
        this.serviceCartography = serviceCartography;
        this.serviceUser = serviceUser;
    }

    @Override
    public StreamResponse getStreamResponse(ContactFilter filter) throws IOException {

//        Company company = null;
//        if (context != null && context.length > 0) {
//            String companyId = (String)context[0];
//            company = serviceUser.getCompany(companyId);
//        }

        return new KmlStreamResponse(
            serviceCartography.exportContactStatisticsKml(filter)
        );
    }
}
