/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.wao.ui.components;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.AfterRenderBody;
import org.apache.tapestry5.annotations.BeforeRenderBody;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.json.JSONObject;
import org.chenillekit.tapestry.core.base.AbstractWindow;

/**
 * Created: 12 juin 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: MinimalWindow.java 590 2010-07-06 14:09:45Z fdesbois $
 */
public class MinimalWindow extends AbstractWindow {

    @Environmental
    private RenderSupport renderSupport;

    @Parameter
    private Integer top;

    @Parameter
    private Integer bottom;

    @Parameter
    private Integer right;

    @Parameter
    private Integer left;

    private boolean hasBody = false;

    /**
     * Tapestry render phase method.
     * Called before component body is rendered.
     *
     * @param writer the markup writer
     */
    @BeforeRenderBody
    void beforeRenderBody(MarkupWriter writer)
    {
        hasBody = true;
        writer.element("div",
                       "id", getClientId() + "Content",
                       "style", "display:none;");
    }

    /**
     * Tapestry render phase method.
     * Called after component body is rendered.
     * return false to render body again.
     *
     * @param writer the markup writer
     */
    @AfterRenderBody
    void afterRenderBody(MarkupWriter writer)
    {
        writer.end();
    }


    /**
     * Tapestry render phase method. End a tag here.
     *
     * @param writer the markup writer
     */
    @AfterRender
    void afterRender(MarkupWriter writer)
    {
        JSONObject options = new JSONObject();

        options.put("className", getClassName());
        options.put("width", getWidth());
        options.put("height", getHeight());
        options.put("id", getClientId());
        options.put("title", getTitle());
        options.put("draggable", false);
        options.put("closable", false);
        options.put("minimizable", false);
        options.put("maximizable", false);
        if (top != null) {
            options.put("top", top);
        }
        if (bottom != null) {
            options.put("bottom", bottom);
        }
        if (right != null) {
            options.put("right", right);
        }
        if (left != null) {
            options.put("left", left);
        }

        //
        // Let subclasses do more.
        //
        configure(options);

        renderSupport.addScript("%s = new Window(%s);", getClientId(), options);

        if (hasBody)
            renderSupport.addScript("%s.setContent('%sContent');", getClientId(), getClientId());

        if (isShow())
            renderSupport.addScript("%s.show%s(%s);", getClientId(), isCenter() ? "Center" : "", isModal());
    }
}
