/*
 * *##% 
 * Wao :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package fr.ifremer.wao.ui.data;

/**
 * SynthesisID$
 *
 * Created: 9 févr. 2010
 *
 * @author fdesbois
 * @version $Revision: 355 $
 *
 * Mise a jour: $Date: 2010-02-16 14:56:07 +0100 (mar., 16 févr. 2010) $
 * par : $Author$
 */
public enum SynthesisId {

    GRAPH_SAMPLING("graph1"),
    GRAPH_BOARDING("graph2"),
    IND_NON_COMPLIANCE_BOARDING("ind1"),
    IND_CONTACT_STATE("ind2"),
    IND_ALLEGRO_REACTIVITY("ind3");
    private String blockId;

    SynthesisId(String blockId) {
        this.blockId = blockId;
    }

    public String getBlockId() {
        return blockId;
    }

    public static SynthesisId getSynthesisID(String blockId) {
        if (blockId.equals(GRAPH_SAMPLING.getBlockId())) {
            return GRAPH_SAMPLING;
        } else if (blockId.equals(GRAPH_BOARDING.getBlockId())) {
            return GRAPH_BOARDING;
        } else if (blockId.equals(IND_CONTACT_STATE.getBlockId())) {
            return IND_CONTACT_STATE;
        } else if (blockId.equals(IND_NON_COMPLIANCE_BOARDING.getBlockId())) {
            return IND_NON_COMPLIANCE_BOARDING;
        } else if (blockId.equals(IND_ALLEGRO_REACTIVITY.getBlockId())) {
            return IND_ALLEGRO_REACTIVITY;
        }
        return null;
    }
}
