/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogsTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.SoundEngine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class ApplySpeciesFrequencyRafaleAction {
    private static final Log log = LogFactory.getLog(ApplySpeciesFrequencyRafaleAction.class);
    protected final SpeciesFrequencyUI ui;
    protected final SoundEngine soundEngine;

    public ApplySpeciesFrequencyRafaleAction(SpeciesFrequencyUI ui) {
        this.ui = ui;
        this.soundEngine = ui.getHandler().getContext().getSoundEngine();
    }

    public void applyRafaleStep(Float step, boolean fromIchtyometer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply rafale step: " + step));
        }
        SpeciesFrequencyUIModel model = this.ui.getModel();
        SpeciesFrequencyUIHandler handler = this.ui.getHandler();
        float aroundLengthStep = model.getLengthStep(step.floatValue());
        if (model.isCopyIndividualObservationNothing()) {
            int rowIndex;
            SpeciesFrequencyTableModel tableModel = handler.getTableModel();
            Map<Float, SpeciesFrequencyRowModel> rowsByStep = model.getRowCache();
            SpeciesFrequencyRowModel row = rowsByStep.get(Float.valueOf(aroundLengthStep));
            if (row != null) {
                Integer number = row.getNumber();
                row.setNumber((number == null ? 0 : number) + 1);
                rowIndex = tableModel.updateRow((Serializable)((Object)row));
            } else {
                row = tableModel.createNewRow();
                row.setLengthStep(Float.valueOf(aroundLengthStep));
                row.setNumber(1);
                row.setValid(handler.isRowValid(row));
                ArrayList<Float> steps = new ArrayList<Float>(rowsByStep.keySet());
                steps.add(Float.valueOf(aroundLengthStep));
                Collections.sort(steps);
                rowIndex = steps.indexOf(Float.valueOf(aroundLengthStep));
                tableModel.addNewRow(rowIndex, (Serializable)((Object)row));
            }
            int totalNumber = model.computeTotalNumber();
            model.setTotalNumber(totalNumber);
            SwingUtilities.invokeLater(() -> this.selectRow(this.ui.getTable(), rowIndex));
            if (fromIchtyometer) {
                String unit = model.getLengthStepCaracteristicUnit();
                handler.showInformationMessage(I18n.t((String)"tutti.editSpeciesFrequencies.addMeasure", (Object[])new Object[]{step, Float.valueOf(aroundLengthStep), unit}));
                this.soundEngine.beepOnIchtyometerDataReception(unit, aroundLengthStep);
            }
        }
        JXTable logsTable = this.ui.getLogsTable();
        SpeciesFrequencyLogsTableModel logsTableModel = (SpeciesFrequencyLogsTableModel)((Object)logsTable.getModel());
        SpeciesFrequencyLogRowModel newLogRow = logsTableModel.createNewRow();
        newLogRow.setDate(new Date());
        newLogRow.setLengthStep(step);
        logsTableModel.addNewRow(0, (Serializable)((Object)newLogRow));
        if (model.isAddIndividualObservationOnRafale()) {
            IndividualObservationBatchTableModel obsTableModel = (IndividualObservationBatchTableModel)((Object)this.ui.getObsTable().getModel());
            IndividualObservationBatchRowModel obsRow = obsTableModel.getEmptyRow();
            if (obsRow == null) {
                obsRow = obsTableModel.createNewRow();
                obsTableModel.addNewRow(obsRow);
            }
            obsRow.setSize(step);
            obsTableModel.updateRow(obsRow);
            newLogRow.setObsRow(obsRow);
            int rowIndex = obsTableModel.getRowIndex(obsRow);
            SwingUtilities.invokeLater(() -> this.selectRow(this.ui.getObsTable(), rowIndex));
        }
    }

    protected void selectRow(JXTable table, int rowIndex) {
        table.setRowSelectionInterval(rowIndex, rowIndex);
        table.scrollRowToVisible(rowIndex);
    }
}

